package com.voxeet.sdk.json;

import android.support.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.voxeet.sdk.utils.Annotate;
import com.voxeet.sdk.utils.NoDocumentation;

/**
 * Class representing the participant information.
 */
@Annotate
@JsonIgnoreProperties(ignoreUnknown = true)
public class ParticipantInfo {

    private String name;

    private String externalId;

    private String avatarUrl;

    @NoDocumentation
    public ParticipantInfo() {
        this.name = "";

        this.externalId = "";

        this.avatarUrl = "";
    }

    @NoDocumentation
    public ParticipantInfo(String name, String externalId, String avatarUrl) {
        this.name = name;

        this.externalId = externalId;

        this.avatarUrl = avatarUrl;
    }

    /**
     * Informs about the participant's name
     * @return the participant's name
     */
    @Nullable
    public String getName() {
        return name;
    }

    @NoDocumentation
    public ParticipantInfo setName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Informs about the participant's external ID
     * @return the participant's external ID
     */
    @Nullable
    public String getExternalId() {
        return externalId;
    }

    @NoDocumentation
    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    /**
     * Informs about the participant's avatar url
     * @return the participant's avatar url
     */
    @Nullable
    public String getAvatarUrl() {
        return avatarUrl;
    }

    @NoDocumentation
    public ParticipantInfo setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
        return this;
    }

    @Override
    public String toString() {
        return "ParticipantInfo{" +
                "name='" + name + '\'' +
                ", externalId='" + externalId + '\'' +
                ", avatarUrl='" + avatarUrl + '\'' +
                '}';
    }
}
