/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.audio;

import android.content.Context;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.os.Build;
import android.os.Process;
import android.util.Log;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.webrtc.CalledByNative;
import org.webrtc.Logging;
import org.webrtc.ThreadUtils;
import org.webrtc.audio.JavaAudioDeviceModule;
import org.webrtc.audio.WebRtcAudioEffects;
import org.webrtc.audio.WebRtcAudioUtils;

class WebRtcAudioRecordWithActivation {
    private static final String TAG = "WebRtcAudioRecordExternal";
    private static final int BITS_PER_SAMPLE = 16;
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final int BUFFERS_PER_SECOND = 100;
    private static final int BUFFER_SIZE_FACTOR = 2;
    private static final long AUDIO_RECORD_THREAD_JOIN_TIMEOUT_MS = 2000L;
    public static final int DEFAULT_AUDIO_SOURCE = 7;
    private final Context context;
    private final AudioManager audioManager;
    private final int audioSource;
    private long nativeAudioRecord;
    private final WebRtcAudioEffects effects = new WebRtcAudioEffects();
    @Nullable
    private ByteBuffer byteBuffer;
    @Nullable
    private AudioRecord audioRecord;
    @Nullable
    private AudioRecordThread audioThread;
    private volatile boolean microphoneMute;
    private byte[] emptyBytes;
    @Nullable
    private final JavaAudioDeviceModule.AudioRecordErrorCallback errorCallback;
    @Nullable
    private final JavaAudioDeviceModule.SamplesReadyCallback audioSamplesReadyCallback;
    private final boolean isAcousticEchoCancelerSupported;
    private final boolean isNoiseSuppressorSupported;
    public static boolean activated = true;

    @CalledByNative
    WebRtcAudioRecordWithActivation(Context context, AudioManager audioManager) {
        this(context, audioManager, 7, null, null, WebRtcAudioEffects.isAcousticEchoCancelerSupported(), WebRtcAudioEffects.isNoiseSuppressorSupported());
    }

    public WebRtcAudioRecordWithActivation(Context context, AudioManager audioManager, int audioSource, @Nullable JavaAudioDeviceModule.AudioRecordErrorCallback errorCallback, @Nullable JavaAudioDeviceModule.SamplesReadyCallback audioSamplesReadyCallback, boolean isAcousticEchoCancelerSupported, boolean isNoiseSuppressorSupported) {
        if (isAcousticEchoCancelerSupported && !WebRtcAudioEffects.isAcousticEchoCancelerSupported()) {
            throw new IllegalArgumentException("HW AEC not supported");
        }
        if (isNoiseSuppressorSupported && !WebRtcAudioEffects.isNoiseSuppressorSupported()) {
            throw new IllegalArgumentException("HW NS not supported");
        }
        this.context = context;
        this.audioManager = audioManager;
        this.audioSource = audioSource;
        this.errorCallback = errorCallback;
        this.audioSamplesReadyCallback = audioSamplesReadyCallback;
        this.isAcousticEchoCancelerSupported = isAcousticEchoCancelerSupported;
        this.isNoiseSuppressorSupported = isNoiseSuppressorSupported;
    }

    @CalledByNative
    public void setNativeAudioRecord(long nativeAudioRecord) {
        this.nativeAudioRecord = nativeAudioRecord;
    }

    @CalledByNative
    boolean isAcousticEchoCancelerSupported() {
        return this.isAcousticEchoCancelerSupported;
    }

    @CalledByNative
    boolean isNoiseSuppressorSupported() {
        return this.isNoiseSuppressorSupported;
    }

    @CalledByNative
    private boolean enableBuiltInAEC(boolean enable) {
        Logging.d(TAG, "enableBuiltInAEC(" + enable + ")");
        return this.effects.setAEC(enable);
    }

    @CalledByNative
    private boolean enableBuiltInNS(boolean enable) {
        Logging.d(TAG, "enableBuiltInNS(" + enable + ")");
        return this.effects.setNS(enable);
    }

    @CalledByNative
    private int initRecording(int sampleRate, int channels) {
        Logging.d(TAG, "initRecording(sampleRate=" + sampleRate + ", channels=" + channels + ")");
        if (this.audioRecord != null) {
            this.reportWebRtcAudioRecordInitError("InitRecording called twice without StopRecording.");
            return -1;
        }
        int bytesPerFrame = channels * 2;
        int framesPerBuffer = sampleRate / 100;
        this.byteBuffer = ByteBuffer.allocateDirect(bytesPerFrame * framesPerBuffer);
        if (!this.byteBuffer.hasArray()) {
            this.reportWebRtcAudioRecordInitError("ByteBuffer does not have backing array.");
            return -1;
        }
        Logging.d(TAG, "byteBuffer.capacity: " + this.byteBuffer.capacity());
        this.emptyBytes = new byte[this.byteBuffer.capacity()];
        this.nativeCacheDirectBufferAddress(this.nativeAudioRecord, this.byteBuffer);
        int channelConfig = this.channelCountToConfiguration(channels);
        int minBufferSize = AudioRecord.getMinBufferSize((int)sampleRate, (int)channelConfig, (int)2);
        if (minBufferSize == -1 || minBufferSize == -2) {
            this.reportWebRtcAudioRecordInitError("AudioRecord.getMinBufferSize failed: " + minBufferSize);
            return -1;
        }
        Logging.d(TAG, "AudioRecord.getMinBufferSize: " + minBufferSize);
        int bufferSizeInBytes = Math.max(2 * minBufferSize, this.byteBuffer.capacity());
        Logging.d(TAG, "bufferSizeInBytes: " + bufferSizeInBytes);
        if (!activated) {
            // empty if block
        }
        try {
            this.audioRecord = new AudioRecord(this.audioSource, sampleRate, channelConfig, 2, bufferSizeInBytes);
        }
        catch (IllegalArgumentException e) {
            this.reportWebRtcAudioRecordInitError("AudioRecord ctor error: " + e.getMessage());
            this.releaseAudioResources();
            return -1;
        }
        if (this.audioRecord == null || this.audioRecord.getState() != 1) {
            this.reportWebRtcAudioRecordInitError("Failed to create a new AudioRecord instance");
            this.releaseAudioResources();
            return -1;
        }
        this.effects.enable(this.audioRecord.getAudioSessionId());
        this.logMainParameters();
        this.logMainParametersExtended();
        return framesPerBuffer;
    }

    @CalledByNative
    private boolean startRecording() {
        Logging.d(TAG, "startRecording");
        if (!activated) {
            this.audioThread = new AudioRecordThread("AudioRecordDeactivatedJavaThread");
            this.audioThread.start();
            return true;
        }
        WebRtcAudioRecordWithActivation.assertTrue(this.audioRecord != null);
        WebRtcAudioRecordWithActivation.assertTrue(this.audioThread == null);
        try {
            this.audioRecord.startRecording();
        }
        catch (IllegalStateException e) {
            this.reportWebRtcAudioRecordStartError(JavaAudioDeviceModule.AudioRecordStartErrorCode.AUDIO_RECORD_START_EXCEPTION, "AudioRecord.startRecording failed: " + e.getMessage());
            return false;
        }
        if (this.audioRecord.getRecordingState() != 3) {
            this.reportWebRtcAudioRecordStartError(JavaAudioDeviceModule.AudioRecordStartErrorCode.AUDIO_RECORD_START_STATE_MISMATCH, "AudioRecord.startRecording failed - incorrect state :" + this.audioRecord.getRecordingState());
            return false;
        }
        this.audioThread = new AudioRecordThread("AudioRecordJavaThread");
        this.audioThread.start();
        return true;
    }

    @CalledByNative
    private boolean stopRecording() {
        Logging.d(TAG, "stopRecording");
        WebRtcAudioRecordWithActivation.assertTrue(this.audioThread != null);
        this.audioThread.stopThread();
        if (!ThreadUtils.joinUninterruptibly(this.audioThread, 2000L)) {
            Logging.e(TAG, "Join of AudioRecordJavaThread timed out");
            WebRtcAudioUtils.logAudioState(TAG, this.context, this.audioManager);
        }
        this.audioThread = null;
        this.effects.release();
        this.releaseAudioResources();
        return true;
    }

    private void logMainParameters() {
        Logging.d(TAG, "AudioRecord: session ID: " + this.audioRecord.getAudioSessionId() + ", channels: " + this.audioRecord.getChannelCount() + ", sample rate: " + this.audioRecord.getSampleRate());
    }

    private void logMainParametersExtended() {
        if (Build.VERSION.SDK_INT >= 23) {
            Logging.d(TAG, "AudioRecord: buffer size in frames: " + this.audioRecord.getBufferSizeInFrames());
        }
    }

    private static void assertTrue(boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    private int channelCountToConfiguration(int channels) {
        return channels == 1 ? 16 : 12;
    }

    private native void nativeCacheDirectBufferAddress(long var1, ByteBuffer var3);

    private native void nativeDataIsRecorded(long var1, int var3);

    public void setMicrophoneMute(boolean mute) {
        Logging.w(TAG, "setMicrophoneMute(" + mute + ")");
        this.microphoneMute = mute;
    }

    private void releaseAudioResources() {
        Logging.d(TAG, "releaseAudioResources");
        if (this.audioRecord != null) {
            this.audioRecord.release();
            this.audioRecord = null;
        }
    }

    private void reportWebRtcAudioRecordInitError(String errorMessage) {
        Logging.e(TAG, "Init recording error: " + errorMessage);
        WebRtcAudioUtils.logAudioState(TAG, this.context, this.audioManager);
        if (this.errorCallback != null) {
            this.errorCallback.onWebRtcAudioRecordInitError(errorMessage);
        }
    }

    private void reportWebRtcAudioRecordStartError(JavaAudioDeviceModule.AudioRecordStartErrorCode errorCode, String errorMessage) {
        Logging.e(TAG, "Start recording error: " + (Object)((Object)errorCode) + ". " + errorMessage);
        WebRtcAudioUtils.logAudioState(TAG, this.context, this.audioManager);
        if (this.errorCallback != null) {
            this.errorCallback.onWebRtcAudioRecordStartError(errorCode, errorMessage);
        }
    }

    private void reportWebRtcAudioRecordError(String errorMessage) {
        Logging.e(TAG, "Run-time recording error: " + errorMessage);
        WebRtcAudioUtils.logAudioState(TAG, this.context, this.audioManager);
        if (this.errorCallback != null) {
            this.errorCallback.onWebRtcAudioRecordError(errorMessage);
        }
    }

    private class AudioRecordThread
    extends Thread {
        private volatile boolean keepAlive;
        private boolean activated;

        public AudioRecordThread(String name) {
            super(name);
            this.keepAlive = true;
            this.activated = false;
        }

        public AudioRecordThread(String name, boolean activated) {
            this(name);
            Log.d((String)"AudioRecordThread", (String)("AudioRecordThread: creating a specific AudioRecordThread :: " + activated));
            this.activated = activated;
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)-19);
            Logging.d(WebRtcAudioRecordWithActivation.TAG, "AudioRecordThread" + WebRtcAudioUtils.getThreadInfo());
            WebRtcAudioRecordWithActivation.assertTrue(WebRtcAudioRecordWithActivation.this.audioRecord.getRecordingState() == 3);
            long lastTime = System.nanoTime();
            while (this.keepAlive) {
                int bytesRead = 0;
                if (this.activated) {
                    bytesRead = WebRtcAudioRecordWithActivation.this.audioRecord.read(WebRtcAudioRecordWithActivation.this.byteBuffer, WebRtcAudioRecordWithActivation.this.byteBuffer.capacity());
                } else {
                    bytesRead = WebRtcAudioRecordWithActivation.this.emptyBytes.length;
                    WebRtcAudioRecordWithActivation.this.byteBuffer.clear();
                    WebRtcAudioRecordWithActivation.this.byteBuffer.put(WebRtcAudioRecordWithActivation.this.emptyBytes);
                }
                if (bytesRead == WebRtcAudioRecordWithActivation.this.byteBuffer.capacity()) {
                    if (WebRtcAudioRecordWithActivation.this.microphoneMute) {
                        WebRtcAudioRecordWithActivation.this.byteBuffer.clear();
                        WebRtcAudioRecordWithActivation.this.byteBuffer.put(WebRtcAudioRecordWithActivation.this.emptyBytes);
                    }
                    if (this.keepAlive) {
                        WebRtcAudioRecordWithActivation.this.nativeDataIsRecorded(WebRtcAudioRecordWithActivation.this.nativeAudioRecord, bytesRead);
                    }
                    if (WebRtcAudioRecordWithActivation.this.audioSamplesReadyCallback == null) continue;
                    byte[] data = Arrays.copyOfRange(WebRtcAudioRecordWithActivation.this.byteBuffer.array(), WebRtcAudioRecordWithActivation.this.byteBuffer.arrayOffset(), WebRtcAudioRecordWithActivation.this.byteBuffer.capacity() + WebRtcAudioRecordWithActivation.this.byteBuffer.arrayOffset());
                    WebRtcAudioRecordWithActivation.this.audioSamplesReadyCallback.onWebRtcAudioRecordSamplesReady(new JavaAudioDeviceModule.AudioSamples(WebRtcAudioRecordWithActivation.this.audioRecord.getAudioFormat(), WebRtcAudioRecordWithActivation.this.audioRecord.getChannelCount(), WebRtcAudioRecordWithActivation.this.audioRecord.getSampleRate(), data));
                    continue;
                }
                String errorMessage = "AudioRecord.read failed: " + bytesRead;
                Logging.e(WebRtcAudioRecordWithActivation.TAG, errorMessage);
                if (bytesRead != -3) continue;
                this.keepAlive = false;
                WebRtcAudioRecordWithActivation.this.reportWebRtcAudioRecordError(errorMessage);
            }
            try {
                if (WebRtcAudioRecordWithActivation.this.audioRecord != null) {
                    WebRtcAudioRecordWithActivation.this.audioRecord.stop();
                }
            }
            catch (IllegalStateException e) {
                Logging.e(WebRtcAudioRecordWithActivation.TAG, "AudioRecord.stop failed: " + e.getMessage());
            }
        }

        public void stopThread() {
            Logging.d(WebRtcAudioRecordWithActivation.TAG, "stopThread");
            this.keepAlive = false;
            this.activated = false;
        }
    }
}

