/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.util.IdentityHashMap;
import java.util.LinkedList;
import org.webrtc.MediaStreamTrack;
import org.webrtc.VideoRenderer;
import org.webrtc.VideoSink;

public class VideoTrack
extends MediaStreamTrack {
    private final LinkedList<VideoRenderer> renderers = new LinkedList();
    private final IdentityHashMap<VideoSink, Long> sinks = new IdentityHashMap();

    public VideoTrack(long nativeTrack) {
        super(nativeTrack);
    }

    public void addSink(VideoSink sink) {
        long nativeSink = VideoTrack.nativeWrapSink(sink);
        this.sinks.put(sink, nativeSink);
        VideoTrack.nativeAddSink(this.nativeTrack, nativeSink);
    }

    public void removeSink(VideoSink sink) {
        long nativeSink = this.sinks.remove(sink);
        if (nativeSink != 0L) {
            VideoTrack.nativeRemoveSink(this.nativeTrack, nativeSink);
            VideoTrack.nativeFreeSink(nativeSink);
        }
    }

    public void addRenderer(VideoRenderer renderer) {
        this.renderers.add(renderer);
        VideoTrack.nativeAddSink(this.nativeTrack, renderer.nativeVideoRenderer);
    }

    public void removeRenderer(VideoRenderer renderer) {
        if (!this.renderers.remove(renderer)) {
            return;
        }
        VideoTrack.nativeRemoveSink(this.nativeTrack, renderer.nativeVideoRenderer);
        renderer.dispose();
    }

    @Override
    public void dispose() {
        while (!this.renderers.isEmpty()) {
            this.removeRenderer(this.renderers.getFirst());
        }
        for (long nativeSink : this.sinks.values()) {
            VideoTrack.nativeRemoveSink(this.nativeTrack, nativeSink);
            VideoTrack.nativeFreeSink(nativeSink);
        }
        this.sinks.clear();
        super.dispose();
    }

    private static native void nativeAddSink(long var0, long var2);

    private static native void nativeRemoveSink(long var0, long var2);

    private static native long nativeWrapSink(VideoSink var0);

    private static native void nativeFreeSink(long var0);
}

