/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.android.media;

import android.content.Context;
import android.content.Intent;
import android.media.projection.MediaProjection;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.android.media.MediaEngineException;
import com.voxeet.android.media.MediaStream;
import com.voxeet.android.media.SdpCandidate;
import com.voxeet.android.media.stats.LocalStats;
import com.voxeet.android.media.video.Camera1Enumerator;
import com.voxeet.android.media.video.Camera2Enumerator;
import com.voxeet.android.media.video.CameraEnumeratorInterface;
import com.voxeet.android.media.video.VideoCapturerConstraintsHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.webrtc.CameraVideoCapturer;
import org.webrtc.EglBase;
import org.webrtc.ScreenCapturerAndroid;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.VideoCapturer;
import org.webrtc.VideoRenderer;
import org.webrtc.VideoStreamRenderer;
import org.webrtc.VideoTrackSourceObserver;
import org.webrtc.voiceengine.WebRtcAudioManager;

public abstract class MediaEngine {
    public static final VideoCapturerConstraintsHolder CAPTURER_CONSTRAINTS_HOLDER = new VideoCapturerConstraintsHolder();
    private static HandlerThread ThreadHandler;
    private CameraVideoCapturer.CameraEventsHandler mCameraListener;
    private Handler mHandler;
    public static final String TAG;
    private static final String VIDEO_CAPTURER_THREAD_NAME = "VideoCapturerThread";
    public static Context Context;
    private static AtomicBoolean Registered;
    @NonNull
    protected StreamListener mStreamListener;
    private List<VideoStreamRenderer> mRenderers;
    private List<String> mScreenShareIdList = new ArrayList<String>();
    private boolean isMuted = false;
    @NonNull
    private EglBase eglBase = EglBase.createEgl10(EglBase.CONFIG_PIXEL_BUFFER);
    private CameraVideoCapturer videoCapturer = null;
    private long capturerNativeSource = 0L;
    private ScreenCapturerAndroid screenCapturer = null;
    private long screenNativeSource = 0L;
    private CameraEnumeratorInterface cameraEnumerator;

    private static void loadLibrary(@NonNull String path) {
        try {
            System.loadLibrary(path);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.getMessage());
        }
        catch (UnsatisfiedLinkError e) {
            Log.d((String)TAG, (String)"unsupported device architecture");
            Log.e((String)TAG, (String)e.getMessage());
        }
    }

    private MediaEngine() {
        this.mRenderers = new ArrayList<VideoStreamRenderer>();
        try {
            if (Build.VERSION.SDK_INT >= 18) {
                this.eglBase = EglBase.createEgl14(EglBase.CONFIG_PIXEL_BUFFER);
            }
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"MediaEngine: error while initializing EGL14. Should not happen, please report");
            e.printStackTrace();
        }
        CAPTURER_CONSTRAINTS_HOLDER.setWidth(640).setHeight(480).setFrameRate(25);
    }

    public MediaEngine(final @NonNull Context context, final @NonNull String peer, @NonNull StreamListener streamListener, @NonNull CameraVideoCapturer.CameraEventsHandler cameraListener, boolean startWithVideo, boolean microphone) throws MediaEngineException {
        this();
        Context = context;
        WebRtcAudioManager.setStereoOutput(true);
        WebRtcAudioManager.setBlacklistDeviceForOpenSLESUsage(true);
        Context = context;
        this.mStreamListener = streamListener;
        this.mCameraListener = cameraListener;
        this.cameraEnumerator = Build.VERSION.SDK_INT >= 21 ? new Camera2Enumerator(context) : new Camera1Enumerator(context);
        if (startWithVideo) {
            String name = this.cameraEnumerator.getNameOfFrontFacingDevice();
            if (null == name) {
                name = this.cameraEnumerator.getNameOfBackFacingDevice();
            }
            this.videoCapturer = this.createVideoCapturer(name, this.mCameraListener);
        }
        if (null == ThreadHandler) {
            ThreadHandler = new HandlerThread("SDK");
            ThreadHandler.start();
        }
        this.mHandler = new Handler(ThreadHandler.getLooper());
        final CountDownLatch latch = new CountDownLatch(1);
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (!MediaEngine.this.Init(context, peer, MediaEngine.this.eglBase.getEglBaseContext(), MediaEngine.this.videoCapturer)) {
                    try {
                        throw new MediaEngineException("An error occurred during init");
                    }
                    catch (MediaEngineException e) {
                        e.printStackTrace();
                    }
                }
                latch.countDown();
            }
        });
        this.waitFor(latch);
    }

    public void stop() {
        final CountDownLatch latch = new CountDownLatch(1);
        this.mStreamListener.onShutdown();
        this.stopScreenCapturer();
        this.stopVideo();
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                MediaEngine.this.Release();
                latch.countDown();
            }
        });
        this.waitFor(latch);
    }

    public void startVideo() {
        String name = this.cameraEnumerator.getNameOfFrontFacingDevice();
        if (null == name) {
            this.cameraEnumerator.getNameOfBackFacingDevice();
        }
        if (null != name) {
            this.startVideo(name);
        }
    }

    public void startScreenCapturer(Intent mediaProjectionPermissionResultData, int width, int height) {
        if (Build.VERSION.SDK_INT >= 21 && null == this.screenCapturer) {
            this.screenCapturer = new ScreenCapturerAndroid(mediaProjectionPermissionResultData, new MediaProjection.Callback(){

                public void onStop() {
                    super.onStop();
                    MediaEngine.this.stopScreenCapturer();
                }
            });
            this.initVideoCapturer(this.screenCapturer, true, width, height);
            this.StartScreenShare(this.screenNativeSource);
        }
    }

    public void stopScreenCapturer() {
        if (null != this.screenCapturer) {
            try {
                this.screenCapturer.stopCapture();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.StopScreenShare();
            this.screenCapturer.dispose();
            this.screenCapturer = null;
            this.screenNativeSource = 0L;
        }
    }

    private void initVideoCapturer(@NonNull VideoCapturer capturer, boolean isScreenShare, int width, int height) {
        VideoTrackSourceObserver capturerObserver;
        EglBase.Context eglContext = this.eglBase.getEglBaseContext();
        SurfaceTextureHelper surfaceTextureHelper = SurfaceTextureHelper.create(VIDEO_CAPTURER_THREAD_NAME, eglContext);
        if (!isScreenShare) {
            this.capturerNativeSource = this.CreateVideoSource(surfaceTextureHelper, false);
            capturerObserver = new VideoTrackSourceObserver(this.capturerNativeSource);
        } else {
            this.screenNativeSource = this.CreateVideoSource(surfaceTextureHelper, false);
            capturerObserver = new VideoTrackSourceObserver(this.screenNativeSource);
        }
        capturer.initialize(surfaceTextureHelper, Context, capturerObserver);
        capturer.startCapture(width, height, CAPTURER_CONSTRAINTS_HOLDER.getFrameRate());
    }

    private CameraVideoCapturer createVideoCapturer(@NonNull String cameraName, CameraVideoCapturer.CameraEventsHandler cameraListener) {
        CameraVideoCapturer capturer = this.cameraEnumerator.createCapturer(cameraName, cameraListener);
        this.initVideoCapturer(capturer, false, CAPTURER_CONSTRAINTS_HOLDER.getWidth(), CAPTURER_CONSTRAINTS_HOLDER.getHeight());
        return capturer;
    }

    public void startVideo(@Nullable String cameraName) {
        if (this.videoCapturer == null) {
            if (null == cameraName && null == (cameraName = this.cameraEnumerator.getNameOfFrontFacingDevice())) {
                cameraName = this.cameraEnumerator.getNameOfBackFacingDevice();
            }
            this.videoCapturer = this.createVideoCapturer(cameraName, this.mCameraListener);
            if (this.capturerNativeSource != 0L) {
                this.StartVideo(this.capturerNativeSource);
            }
        }
    }

    public void stopVideo() {
        if (this.videoCapturer != null) {
            try {
                this.videoCapturer.stopCapture();
            }
            catch (InterruptedException e) {
                Log.e((String)TAG, (String)e.getMessage());
            }
            this.StopVideo();
            this.videoCapturer.dispose();
            this.videoCapturer = null;
            this.capturerNativeSource = 0L;
        }
    }

    public void switchCamera(@Nullable CameraVideoCapturer.CameraSwitchHandler handler) {
        if (this.videoCapturer != null) {
            this.videoCapturer.switchCamera(handler);
        }
    }

    public void attachMediaStream(VideoRenderer.Callbacks callbacks, MediaStream stream) {
        VideoStreamRenderer renderer = null;
        for (VideoStreamRenderer r : this.mRenderers) {
            if (r.callbacks() != callbacks) continue;
            renderer = r;
            break;
        }
        if (renderer == null) {
            renderer = new VideoStreamRenderer(callbacks);
            this.mRenderers.add(renderer);
        }
        this.AttachMediaStream(stream.peerId(), stream.label(), renderer.nativeVideoRenderer());
    }

    public void unattachMediaStream(VideoRenderer.Callbacks callbacks, MediaStream stream) {
        VideoStreamRenderer renderer = null;
        for (VideoStreamRenderer r : this.mRenderers) {
            if (r.callbacks() != callbacks) continue;
            renderer = r;
            break;
        }
        if (renderer != null && stream != null) {
            this.UnAttachMediaStream(stream.peerId(), stream.label(), renderer.nativeVideoRenderer());
        }
    }

    public void removePeer(@Nullable String peer) {
        Log.d((String)TAG, (String)("removePeer: trying to remove peer " + peer + Looper.myLooper() + " " + Looper.getMainLooper()));
        if (null != peer && !this.ClosePeerConnection(peer)) {
            Log.w((String)TAG, (String)String.format("Unable to close peer connection for peer: %s", peer));
        }
    }

    public void changePeerPosition(String peer, double angle, double distance) {
        if (!this.SetPeerPosition(peer, angle, distance)) {
            Log.w((String)TAG, (String)String.format("Unable to change position for peer: %s", peer));
        }
    }

    public void changePeerPosition(String peer, double angle, double distance, float gain) {
    }

    public void changePeerGain(String peer, float gain) {
    }

    public void mute() {
        this.isMuted = true;
        this.SetMute(true);
    }

    public void unMute() {
        this.isMuted = false;
        this.SetMute(false);
    }

    public boolean isMuted() {
        return this.isMuted;
    }

    public int getLocalVuMeter() {
        return this.GetLocalVuMeter();
    }

    public double getPeerVuMeter(@NonNull String peer) {
        return this.GetPeerVuMeter(peer);
    }

    @NonNull
    public LocalStats getLocalStats(@NonNull String peer) {
        return this.GetLocalStats(peer);
    }

    public boolean createPeerConnection(String peer, boolean master) throws MediaEngineException {
        return this.CreatePeerConnection(peer, master);
    }

    public boolean createAnswer(@NonNull String peer) {
        return this.CreateAnswer(peer);
    }

    public boolean setPeerDescription(@NonNull String peer, long ssrc, @NonNull String type, @NonNull String sdp) {
        return this.SetPeerDescription(peer, ssrc, type, sdp);
    }

    public boolean setPeerCandidate(@NonNull String peer, @NonNull String sdpMid, int sdpMLineIndex, @NonNull String sdp) {
        return this.SetPeerCandidate(peer, sdpMid, sdpMLineIndex, sdp);
    }

    public abstract void onSessionCreated(String var1, String var2, String var3);

    public abstract void onIceCandidateDiscovered(String var1, SdpCandidate[] var2);

    public abstract void onIceGatheringComplete(String var1);

    public void onStreamAdded(String peer, long nativeStream) {
        Log.d((String)TAG, (String)"Java stream added");
        MediaStream stream = new MediaStream(peer, nativeStream);
        this.mStreamListener.onStreamAdded(peer, stream);
    }

    public void onStreamUpdated(String peer, long nativeStream) {
        Log.d((String)TAG, (String)"Java stream updated");
        MediaStream stream = new MediaStream(peer, nativeStream);
        this.mStreamListener.onStreamUpdated(peer, stream);
    }

    public void onStreamRemoved(String peer, long nativeStream) {
        Log.d((String)TAG, (String)"Java stream removed");
        MediaStream stream = new MediaStream(peer, nativeStream);
        this.mStreamListener.onStreamRemoved(peer);
    }

    public void onScreenStreamAdded(String peer, long nativeStream) {
        Log.d((String)TAG, (String)"Java stream added corresponding to screen");
        MediaStream stream = new MediaStream(peer, nativeStream, true);
        this.mStreamListener.onScreenStreamAdded(peer, stream);
    }

    public void onScreenStreamRemoved(String peer, long nativeStream) {
        Log.d((String)TAG, (String)"Java stream removed corresponding to screen");
        MediaStream stream = new MediaStream(peer, nativeStream, true);
        this.mStreamListener.onScreenStreamRemoved(peer);
    }

    @NonNull
    public EglBase getEglBase() {
        return this.eglBase;
    }

    private void waitFor(@NonNull CountDownLatch latch) {
        try {
            latch.await(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private native boolean Init(@NonNull Context var1, @NonNull String var2, @NonNull EglBase.Context var3, @NonNull VideoCapturer var4);

    private native void Release();

    private native void StartVideo(long var1);

    private native void StopVideo();

    private native void StartScreenShare(long var1);

    private native void StopScreenShare();

    private native long CreateVideoSource(@NonNull SurfaceTextureHelper var1, boolean var2);

    private native void AttachMediaStream(@NonNull String var1, @NonNull String var2, long var3);

    private native void UnAttachMediaStream(@NonNull String var1, @NonNull String var2, long var3);

    private native boolean CreatePeerConnection(@NonNull String var1, boolean var2);

    private native boolean ClosePeerConnection(@NonNull String var1);

    private native boolean CreateAnswer(@NonNull String var1);

    private native boolean SetPeerDescription(@NonNull String var1, long var2, @NonNull String var4, @NonNull String var5);

    private native boolean SetPeerCandidate(@NonNull String var1, @NonNull String var2, int var3, @NonNull String var4);

    private native boolean SetPeerPosition(@NonNull String var1, double var2, double var4);

    private native void SetMute(boolean var1);

    private native int GetLocalVuMeter();

    private native double GetPeerVuMeter(@NonNull String var1);

    @NonNull
    private native LocalStats GetLocalStats(@NonNull String var1);

    static {
        TAG = MediaEngine.class.getSimpleName();
        Registered = new AtomicBoolean(false);
        MediaEngine.loadLibrary("c++_shared");
        MediaEngine.loadLibrary("MediaEngineJni");
    }

    public static interface StreamListener {
        public void onStreamAdded(@NonNull String var1, @NonNull MediaStream var2);

        public void onStreamUpdated(@NonNull String var1, @NonNull MediaStream var2);

        public void onStreamRemoved(@NonNull String var1);

        public void onScreenStreamAdded(@NonNull String var1, @NonNull MediaStream var2);

        public void onScreenStreamRemoved(@NonNull String var1);

        public void onShutdown();

        public void onIceCandidateDiscovered(String var1, SdpCandidate[] var2);
    }
}

