/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.android.media;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.voxeet.android.media.AudioTrack;
import com.voxeet.android.media.VideoTrack;
import java.util.ArrayList;
import java.util.List;

public class MediaStream {
    private String peerId;
    private String label;
    @NonNull
    private List<AudioTrack> audioTrackList = new ArrayList<AudioTrack>();
    @NonNull
    private List<VideoTrack> videoTrackList = new ArrayList<VideoTrack>();
    private boolean isScreenShare;

    public MediaStream(@NonNull String peerId, long nativeMediaStream, boolean isScreenShare) {
        this.peerId = peerId;
        this.nativeInitMediaStream(nativeMediaStream);
        this.isScreenShare = isScreenShare;
    }

    public MediaStream(String peerId, long nativeMediaStream) {
        this(peerId, nativeMediaStream, false);
    }

    private void nativeInitMediaStream(long nativeMediaStream) {
        long[] audioTracks = this.nativeGetAudioTracks(nativeMediaStream);
        long[] videoTracks = this.nativeGetVideoTracks(nativeMediaStream);
        if (null != audioTracks) {
            for (long ptr : audioTracks) {
                this.audioTrackList.add(new AudioTrack(ptr));
            }
        }
        if (null != videoTracks) {
            for (long ptr : videoTracks) {
                this.videoTrackList.add(new VideoTrack(ptr));
            }
        }
    }

    @NonNull
    public List<AudioTrack> audioTracks() {
        return this.audioTrackList;
    }

    @NonNull
    public List<VideoTrack> videoTracks() {
        return this.videoTrackList;
    }

    public String peerId() {
        return this.peerId;
    }

    public String label() {
        return this.label;
    }

    public void label(@NonNull String label) {
        this.label = label;
    }

    public Boolean isScreenShare() {
        return this.isScreenShare;
    }

    @Nullable
    private native long[] nativeGetAudioTracks(long var1);

    @Nullable
    private native long[] nativeGetVideoTracks(long var1);

    public String toString() {
        return "MediaStream{peerId='" + this.peerId + '\'' + ", label='" + this.label + '\'' + ", isScreenShare=" + this.isScreenShare + '}';
    }
}

