/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.nio.ByteBuffer;
import org.webrtc.JavaI420Buffer;
import org.webrtc.VideoFrame;

public class NV21Buffer
implements VideoFrame.Buffer {
    private final byte[] data;
    private final int width;
    private final int height;
    private final Runnable releaseCallback;
    private final Object refCountLock = new Object();
    private int refCount = 1;

    public NV21Buffer(byte[] data, int width, int height, Runnable releaseCallback) {
        this.data = data;
        this.width = width;
        this.height = height;
        this.releaseCallback = releaseCallback;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        return (VideoFrame.I420Buffer)this.cropAndScale(0, 0, this.width, this.height, this.width, this.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retain() {
        Object object = this.refCountLock;
        synchronized (object) {
            ++this.refCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Object object = this.refCountLock;
        synchronized (object) {
            if (--this.refCount == 0 && this.releaseCallback != null) {
                this.releaseCallback.run();
            }
        }
    }

    @Override
    public VideoFrame.Buffer cropAndScale(int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight) {
        JavaI420Buffer newBuffer = JavaI420Buffer.allocate(scaleWidth, scaleHeight);
        NV21Buffer.nativeCropAndScale(cropX, cropY, cropWidth, cropHeight, scaleWidth, scaleHeight, this.data, this.width, this.height, newBuffer.getDataY(), newBuffer.getStrideY(), newBuffer.getDataU(), newBuffer.getStrideU(), newBuffer.getDataV(), newBuffer.getStrideV());
        return newBuffer;
    }

    private static native void nativeCropAndScale(int var0, int var1, int var2, int var3, int var4, int var5, byte[] var6, int var7, int var8, ByteBuffer var9, int var10, ByteBuffer var11, int var12, ByteBuffer var13, int var14);
}

