package com.voxeet.android.media.stats;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;

import com.fasterxml.jackson.databind.ObjectMapper;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class LocalStats extends AbstractStats<JSONArray> {
    private static final String TAG = LocalStats.class.getSimpleName();
    public String userId;

    private List<HashMap<String, Object>> jsonResult;
    private List<AbstractStats<JSONObject>> stats;

    private LocalStats() {
        super();

        stats = new ArrayList<>();
    }

    public LocalStats(@NonNull String userId) {
        this();

        this.userId = userId;
    }

    @NonNull
    public String getUserId() {
        return userId;
    }

    @Nullable
    @Override
    public JSONArray toJson() throws JSONException {
        return new JSONArray(getRawJson());
    }

    @NonNull
    public <STATS> List<STATS> getStatsForClass(Class<STATS> klass) {
        List<STATS> list = new ArrayList<>();
        for (AbstractStats<JSONObject> in_list : stats) {
            if (klass.isAssignableFrom(in_list.getClass())) list.add((STATS) in_list);
        }

        return list;
    }

    public void addStatFromGlobalJson(String jsonArray) {
        setRawJson(jsonArray);
        //parse the dictionnary
        try {
            jsonResult = new ObjectMapper().readValue(jsonArray, ArrayList.class);
        } catch (IOException e) {
            e.printStackTrace();
        }

        //parse the objects
        try {
            JSONArray array = toJson();
            if (null != array) {
                for (int i = 0; i < array.length(); i++) {
                    JSONObject object = array.getJSONObject(i);

                    AbstractStats<JSONObject> stat = StatsBuilderFactory.parseObject(object);
                    if (null != stat) {
                        stats.add(stat);
                    }
                }
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }
}
