/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.android.media.stats;

import android.support.annotation.Nullable;
import android.util.Log;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.voxeet.android.media.stats.AbstractStats;
import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class StatsBuilderFactory {
    private static final String TAG = StatsBuilderFactory.class.getSimpleName();
    private static ObjectMapper sMapper = new ObjectMapper();

    private StatsBuilderFactory() {
    }

    public static AbstractStats<JSONObject> parseObject(JSONObject object) {
        try {
            String string = object.toString();
            AbstractStats result = (AbstractStats)sMapper.readValue(string, AbstractStats.class);
            if (null != result) {
                result.setRawJson(string);
            }
            return result;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"failed to decode command", (Throwable)e);
            Log.d((String)TAG, (String)("parseObject: unknown := " + object.toString()));
            return null;
        }
    }

    @Nullable
    public static JSONArray toJsonArray(String rawJson) {
        try {
            return new JSONArray(rawJson);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static JSONObject toJsonObject(String rawJson) {
        try {
            return new JSONObject(rawJson);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }
}

