/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.android.media.stats;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.voxeet.android.media.stats.AbstractStats;
import com.voxeet.android.media.stats.StatsBuilderFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LocalStats
extends AbstractStats<JSONArray> {
    private static final String TAG = LocalStats.class.getSimpleName();
    public String userId;
    private List<HashMap<String, Object>> jsonResult;
    private List<AbstractStats<JSONObject>> stats = new ArrayList<AbstractStats<JSONObject>>();

    private LocalStats() {
    }

    public LocalStats(@NonNull String userId) {
        this();
        this.userId = userId;
    }

    @NonNull
    public String getUserId() {
        return this.userId;
    }

    @Override
    @Nullable
    public JSONArray toJson() throws JSONException {
        return new JSONArray(this.getRawJson());
    }

    @NonNull
    public <STATS> List<STATS> getStatsForClass(Class<STATS> klass) {
        ArrayList<AbstractStats<JSONObject>> list = new ArrayList<AbstractStats<JSONObject>>();
        for (AbstractStats<JSONObject> in_list : this.stats) {
            if (!klass.isAssignableFrom(in_list.getClass())) continue;
            list.add(in_list);
        }
        return list;
    }

    public void addStatFromGlobalJson(String jsonArray) {
        this.setRawJson(jsonArray);
        try {
            this.jsonResult = (List)new ObjectMapper().readValue(jsonArray, ArrayList.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            JSONArray array = this.toJson();
            if (null != array) {
                for (int i = 0; i < array.length(); ++i) {
                    JSONObject object = array.getJSONObject(i);
                    AbstractStats<JSONObject> stat = StatsBuilderFactory.parseObject(object);
                    if (null == stat) continue;
                    this.stats.add(stat);
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }
}

