package com.voxeet.android.media.video;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.media.projection.MediaProjectionManager;
import android.os.Build;
import android.support.annotation.NonNull;

/**
 * Created by kevinleperf on 14/07/2018.
 */

public class ScreenCapturerHelper {

    public final static int REQUEST_SCREEN_CAPTURE = 67223;

    private ScreenCapturerHelper() {

    }

    public static boolean requestPermissionForScreenCapture(@NonNull Activity activity) {
        if (Build.VERSION_CODES.LOLLIPOP <= Build.VERSION.SDK_INT) {
            MediaProjectionManager manager = (MediaProjectionManager)
                    activity.getSystemService(Context.MEDIA_PROJECTION_SERVICE);
            Intent request = manager.createScreenCaptureIntent();
            activity.startActivityForResult(request, ScreenCapturerHelper.REQUEST_SCREEN_CAPTURE);
            return true;
        }
        return false;
    }
}
