package com.voxeet.android.media.video;

import android.content.Context;

import org.webrtc.Camera1Capturer;
import org.webrtc.CameraVideoCapturer;


public class Camera1Enumerator extends org.webrtc.Camera1Enumerator
        implements CameraEnumeratorInterface {

    private final Context mContext;

    public Camera1Enumerator(Context context) {
        super(false);

        mContext = context;
    }

    public String getNameOfBackFacingDevice() {
        for (String deviceName : this.getDeviceNames()) {
            if (this.isBackFacing(deviceName)) {
                return deviceName;
            }
        }

        return null;
    }

    public String getNameOfFrontFacingDevice() {
        for (String deviceName : this.getDeviceNames()) {
            if (this.isFrontFacing(deviceName)) {
                return deviceName;
            }
        }

        return null;
    }

    @Override
    public CameraVideoCapturer createCapturer(String deviceName, CameraVideoCapturer.CameraEventsHandler eventsHandler) {
        return new Camera1Capturer(deviceName, eventsHandler, false);
    }
}
