package com.voxeet.android.media.stats;

import android.support.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import org.json.JSONException;
import org.json.JSONObject;

@JsonIgnoreProperties(ignoreUnknown = true)
public class RTCPeerConnectionStats extends AbstractStats<JSONObject> {
    public String type;
    public String id;
    public long timestamp;

    public long dataChannelsOpened;
    public long dataChannelsClosed;

    private RTCPeerConnectionStats() {

    }

    @Nullable
    @Override
    public JSONObject toJson() throws JSONException {
        return StatsBuilderFactory.toJsonObject(getRawJson());
    }
}
