package com.voxeet.android.media;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import java.util.ArrayList;
import java.util.List;

/**
 * A Simple media stream for Voxeet
 *
 * @author tgourgues
 */
public class MediaStream {
    /**
     * The peer id of the stream owner
     */
    private String peerId;

    /**
     * The underlying stream label
     */
    private String label;

    /**
     * A list of AudioTracks
     */
    @NonNull
    private List<AudioTrack> audioTrackList = new ArrayList<>();

    /**
     * A list of VideoTracks
     */
    @NonNull
    private List<VideoTrack> videoTrackList = new ArrayList<>();

    /**
     * Flag describing a screen share stream
     */
    private boolean isScreenShare;

    /**
     * MediaStream Constructor
     * @param nativeMediaStream - the native pointer to the MediaStreamInterface for initialization (Will never be retained)
     */
    public MediaStream(String peerId, long nativeMediaStream, boolean isScreenShare) {
        this.peerId = peerId;
        this.nativeInitMediaStream(nativeMediaStream);

        this.isScreenShare = isScreenShare;
    }

    /**
     * MediaStream Constructor
     * @param nativeMediaStream - the native pointer to the MediaStreamInterface for initialization (Will never be retained)
     */
    public MediaStream(String peerId, long nativeMediaStream) {
        this(peerId, nativeMediaStream, false);
    }

    private void nativeInitMediaStream(long nativeMediaStream) {
        long[] audioTracks = this.nativeGetAudioTracks(nativeMediaStream);
        long[] videoTracks = this.nativeGetVideoTracks(nativeMediaStream);

        if(null != audioTracks) {
            for (long ptr : audioTracks) {
                audioTrackList.add(new AudioTrack(ptr));
            }
        }

        if(null != videoTracks) {
            for (long ptr : videoTracks) {
                videoTrackList.add(new VideoTrack(ptr));
            }
        }
    }

    @NonNull
    public List<AudioTrack> audioTracks() {
        return this.audioTrackList;
    }

    @NonNull
    public List<VideoTrack> videoTracks() {
        return this.videoTrackList;
    }

    public String peerId() {
        return this.peerId;
    }

    public String label() {
        return this.label;
    }

    public void label(String label) {
        this.label = label;
    }

    public Boolean isScreenShare() {
        return isScreenShare;
    }

    @Nullable
    private native long[] nativeGetAudioTracks(long nativeMediaStream);

    @Nullable
    private native long[] nativeGetVideoTracks(long nativeMediaStream);
}
