/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.android.media.peer;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.android.media.MediaEngineException;
import com.voxeet.android.media.peer.PendingPeerCallback;
import com.voxeet.android.media.peer.SdpDescription;
import com.voxeet.android.media.peer.SdpMessage;
import com.voxeet.android.media.peer.Type;
import java.util.Collections;

public class PendingPeerOperation
implements PendingPeerCallback {
    private static String TAG = PendingPeerOperation.class.getSimpleName();
    private Handler handle = new Handler(Looper.getMainLooper());
    private String mPeer;
    private Type mType;
    private SdpDescription mValue;
    @Nullable
    private PendingPeerCallback mListener;

    public PendingPeerOperation(Type type, String peer) {
        this.mType = type;
        this.mPeer = peer;
    }

    public void waitOperation(long timeout) throws MediaEngineException {
        Log.d((String)TAG, (String)("waitOperation: " + Looper.myLooper()));
        this.handle.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (PendingPeerOperation.this.mListener != null && PendingPeerOperation.this.mValue == null) {
                    PendingPeerOperation.this.onMessage(null);
                    Log.d((String)TAG, (String)String.format(PendingPeerOperation.this.mType.name(), PendingPeerOperation.this.mPeer));
                }
            }
        }, timeout);
    }

    public boolean tryUnlock(@NonNull Type type, @NonNull String peer, @Nullable SdpDescription value) {
        Log.d((String)TAG, (String)("tryUnlock: " + Looper.myLooper()));
        Log.d((String)TAG, (String)("tryUnlock: " + (Object)((Object)type) + " " + peer + " " + value.getType() + " " + value.getSdp()));
        if (this.mType != type || !this.mPeer.equals(peer)) {
            return false;
        }
        this.mValue = value;
        SdpMessage message = new SdpMessage(value, Collections.emptyList());
        Log.d((String)TAG, (String)("unlocked: " + (Object)((Object)type) + " " + peer + " " + value.getType() + " " + value.getSdp()));
        this.onMessage(message);
        return true;
    }

    public void setListener(@NonNull PendingPeerCallback listener) {
        this.mListener = listener;
    }

    private boolean equals(PendingPeerOperation operation) {
        if (operation == this) {
            return true;
        }
        Log.d((String)TAG, (String)("equals: " + operation.mPeer + " " + this.mPeer + " " + (Object)((Object)this.mType) + " " + (Object)((Object)operation.mType)));
        return this.mType == operation.mType && this.mPeer == operation.mPeer;
    }

    public boolean equals(Object value) {
        Log.d((String)TAG, (String)("equals: " + value));
        if (value != null && value instanceof PendingPeerOperation) {
            return this.equals((PendingPeerOperation)value);
        }
        return false;
    }

    public int hashCode() {
        return this.mType.value() * 397 ^ (this.mPeer != null ? this.mPeer.hashCode() : 0);
    }

    @Override
    public void onMessage(@Nullable SdpMessage message) {
        if (null != message) {
            Log.d((String)TAG, (String)("onMessage: " + message.getDescription().getType() + " " + message.getDescription()));
        } else {
            Log.d((String)TAG, (String)"onMessage: null");
        }
        PendingPeerCallback callback = this.mListener;
        if (null != callback) {
            callback.onMessage(message);
        }
    }
}

