/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.util.Log;
import java.nio.ByteBuffer;
import org.webrtc.JavaI420Buffer;
import org.webrtc.RendererCommon;
import org.webrtc.TextureBufferImpl;
import org.webrtc.VideoFrame;

public class VideoRenderer {
    long nativeVideoRenderer;

    public static native void nativeCopyPlane(ByteBuffer var0, int var1, int var2, int var3, ByteBuffer var4, int var5);

    public static void renderFrameDone(I420Frame frame) {
        frame.yuvPlanes = null;
        frame.textureId = 0;
        if (frame.nativeFramePointer != 0L) {
            VideoRenderer.releaseNativeFrame(frame.nativeFramePointer);
            frame.nativeFramePointer = 0L;
        }
    }

    public VideoRenderer(Callbacks callbacks) {
        this.nativeVideoRenderer = VideoRenderer.nativeWrapVideoRenderer(callbacks);
    }

    public void dispose() {
        if (this.nativeVideoRenderer == 0L) {
            return;
        }
        VideoRenderer.freeWrappedVideoRenderer(this.nativeVideoRenderer);
        this.nativeVideoRenderer = 0L;
    }

    private static native long nativeWrapVideoRenderer(Callbacks var0);

    private static native void freeWrappedVideoRenderer(long var0);

    private static native void releaseNativeFrame(long var0);

    public static interface Callbacks {
        public void renderFrame(I420Frame var1);
    }

    public static class I420Frame {
        public final int width;
        public final int height;
        public final int[] yuvStrides;
        public ByteBuffer[] yuvPlanes;
        public final boolean yuvFrame;
        public final float[] samplingMatrix;
        public int textureId;
        private long nativeFramePointer;
        public int rotationDegree;
        private final VideoFrame.Buffer backingBuffer;

        public I420Frame(int width, int height, int rotationDegree, int[] yuvStrides, ByteBuffer[] yuvPlanes, long nativeFramePointer) {
            this.width = width;
            this.height = height;
            this.yuvStrides = yuvStrides;
            this.yuvPlanes = yuvPlanes;
            this.yuvFrame = true;
            this.rotationDegree = rotationDegree;
            this.nativeFramePointer = nativeFramePointer;
            this.backingBuffer = null;
            if (rotationDegree % 90 != 0) {
                throw new IllegalArgumentException("Rotation degree not multiple of 90: " + rotationDegree);
            }
            this.samplingMatrix = RendererCommon.verticalFlipMatrix();
        }

        public I420Frame(int width, int height, int rotationDegree, int textureId, float[] samplingMatrix, long nativeFramePointer) {
            this.width = width;
            this.height = height;
            this.yuvStrides = null;
            this.yuvPlanes = null;
            this.samplingMatrix = samplingMatrix;
            this.textureId = textureId;
            this.yuvFrame = false;
            this.rotationDegree = rotationDegree;
            this.nativeFramePointer = nativeFramePointer;
            this.backingBuffer = null;
            if (rotationDegree % 90 != 0) {
                throw new IllegalArgumentException("Rotation degree not multiple of 90: " + rotationDegree);
            }
        }

        public I420Frame(int rotationDegree, VideoFrame.Buffer buffer, long nativeFramePointer) {
            this.width = buffer.getWidth();
            this.height = buffer.getHeight();
            this.rotationDegree = rotationDegree;
            if (rotationDegree % 90 != 0) {
                throw new IllegalArgumentException("Rotation degree not multiple of 90: " + rotationDegree);
            }
            if (buffer instanceof VideoFrame.TextureBuffer && ((VideoFrame.TextureBuffer)buffer).getType() == VideoFrame.TextureBuffer.Type.OES) {
                VideoFrame.TextureBuffer textureBuffer = (VideoFrame.TextureBuffer)buffer;
                this.yuvFrame = false;
                this.textureId = textureBuffer.getTextureId();
                this.samplingMatrix = RendererCommon.convertMatrixFromAndroidGraphicsMatrix(textureBuffer.getTransformMatrix());
                this.yuvStrides = null;
                this.yuvPlanes = null;
            } else if (buffer instanceof VideoFrame.I420Buffer) {
                VideoFrame.I420Buffer i420Buffer = (VideoFrame.I420Buffer)buffer;
                this.yuvFrame = true;
                this.yuvStrides = new int[]{i420Buffer.getStrideY(), i420Buffer.getStrideU(), i420Buffer.getStrideV()};
                this.yuvPlanes = new ByteBuffer[]{i420Buffer.getDataY(), i420Buffer.getDataU(), i420Buffer.getDataV()};
                this.samplingMatrix = RendererCommon.verticalFlipMatrix();
                this.textureId = 0;
            } else {
                this.yuvFrame = false;
                this.textureId = 0;
                this.samplingMatrix = null;
                this.yuvStrides = null;
                this.yuvPlanes = null;
            }
            this.nativeFramePointer = nativeFramePointer;
            this.backingBuffer = buffer;
        }

        public int rotatedWidth() {
            return this.rotationDegree % 180 == 0 ? this.width : this.height;
        }

        public int rotatedHeight() {
            return this.rotationDegree % 180 == 0 ? this.height : this.width;
        }

        public String toString() {
            String type = this.yuvFrame ? "Y: " + this.yuvStrides[0] + ", U: " + this.yuvStrides[1] + ", V: " + this.yuvStrides[2] : "Texture: " + this.textureId;
            return this.width + "x" + this.height + ", " + type;
        }

        VideoFrame toVideoFrame() {
            VideoFrame.Buffer buffer;
            Log.d((String)"VideoRenderer", (String)("toVideoFrame: backingBuffer:=" + this.backingBuffer + " yuvFrame:=" + this.yuvFrame));
            if (this.backingBuffer != null) {
                this.backingBuffer.retain();
                VideoRenderer.renderFrameDone(this);
                buffer = this.backingBuffer;
            } else if (this.yuvFrame) {
                buffer = JavaI420Buffer.wrap(this.width, this.height, this.yuvPlanes[0], this.yuvStrides[0], this.yuvPlanes[1], this.yuvStrides[1], this.yuvPlanes[2], this.yuvStrides[2], () -> VideoRenderer.renderFrameDone(this));
            } else {
                Log.d((String)"VideoRenderer", (String)"toVideoFrame: create TextureBufferImpl");
                buffer = new TextureBufferImpl(this.width, this.height, VideoFrame.TextureBuffer.Type.OES, this.textureId, RendererCommon.convertMatrixToAndroidGraphicsMatrix(this.samplingMatrix), null, () -> VideoRenderer.renderFrameDone(this));
            }
            return new VideoFrame(buffer, this.rotationDegree, 0L);
        }
    }
}

