package com.voxeet.android.media.audio;

/**
 * Specific routes for audio devices on Android
 */

public enum AudioRoute {
    ROUTE_HEADSET(0),
    ROUTE_PHONE(1),
    ROUTE_SPEAKER(2),
    ROUTE_BLUETOOTH(3);

    private int mValue;

    private AudioRoute(int value) {
        mValue = value;
    }

    public int value() {
        return mValue;
    }

    public static AudioRoute valueOf(int value) {
        switch (value) {
            case 0:
                return ROUTE_HEADSET;
            case 1:
                return ROUTE_PHONE;
            case 2:
                return ROUTE_SPEAKER;
            case 3:
                return ROUTE_BLUETOOTH;
            default:
                return ROUTE_SPEAKER;
        }
    }
}