package com.voxeet.android.media.video;

import android.content.Context;

import org.webrtc.CameraVideoCapturer;
import org.webrtc.FrameEmitterCamera2Capturer;


public class Camera2Enumerator extends org.webrtc.Camera2Enumerator
        implements CameraEnumeratorInterface {

    private final Context mContext;

    public Camera2Enumerator(Context context) {
        super(context);

        mContext = context;
    }

    public String getNameOfBackFacingDevice() {
        for (String deviceName : this.getDeviceNames()) {
            if (this.isBackFacing(deviceName)) {
                return deviceName;
            }
        }

        return null;
    }

    public String getNameOfFrontFacingDevice() {
        for (String deviceName : this.getDeviceNames()) {
            if (this.isFrontFacing(deviceName)) {
                return deviceName;
            }
        }

        return null;
    }

    @Override
    public CameraVideoCapturer createCapturer(String deviceName, CameraVideoCapturer.CameraEventsHandler eventsHandler) {
        return new FrameEmitterCamera2Capturer(mContext, deviceName, eventsHandler);
    }
}
