package com.voxeet.android.media.audio.focus;

import android.annotation.TargetApi;
import android.media.AudioAttributes;
import android.media.AudioManager;
import android.os.Build;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;

/**
 * Created by kevinleperf on 31/08/2018.
 */

@RequiresApi(api = Build.VERSION_CODES.O)
public class AudioFocusRequest26 implements AudioFocusRequest {

    private final AudioAttributes playbackAttributes;

    private static Handler sHandler = new Handler();
    private final AudioManager.OnAudioFocusChangeListener focusRequest;
    private final android.media.AudioFocusRequest focusRequestBuilt;

    @RequiresApi(Build.VERSION_CODES.O)
    public AudioFocusRequest26() {

        playbackAttributes = new AudioAttributes.Builder()
                .setUsage(AudioAttributes.USAGE_MEDIA)
                .setContentType(AudioAttributes.CONTENT_TYPE_SPEECH)
                .build();

        focusRequest = new AudioManager.OnAudioFocusChangeListener() {
            @Override
            public void onAudioFocusChange(int focusChange) {

            }
        };

        focusRequestBuilt = new android.media.AudioFocusRequest.Builder(AudioManager.AUDIOFOCUS_GAIN)
                .setAudioAttributes(playbackAttributes)
                .setAcceptsDelayedFocusGain(true)
                .setWillPauseWhenDucked(true)
                .setOnAudioFocusChangeListener(focusRequest, sHandler)
                .build();
    }

    @RequiresApi(api = Build.VERSION_CODES.O)
    @Override
    public int requestAudioFocus(@NonNull AudioManager manager) {
        return manager.requestAudioFocus(focusRequestBuilt);
    }

    @RequiresApi(api = Build.VERSION_CODES.O)
    @Override
    public int abandonAudioFocus(@NonNull AudioManager manager) {
        return manager.abandonAudioFocusRequest(focusRequestBuilt);
    }
}
