/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.webrtc.DataChannel;
import org.webrtc.IceCandidate;
import org.webrtc.JniCommon;
import org.webrtc.MediaConstraints;
import org.webrtc.MediaStream;
import org.webrtc.MediaStreamTrack;
import org.webrtc.RTCStatsCollectorCallback;
import org.webrtc.RtpReceiver;
import org.webrtc.RtpSender;
import org.webrtc.SdpObserver;
import org.webrtc.SessionDescription;
import org.webrtc.StatsObserver;
import org.webrtc.TurnCustomizer;

public class PeerConnection {
    private final List<MediaStream> localStreams;
    private final long nativePeerConnection;
    private final long nativeObserver;
    private List<RtpSender> senders;
    private List<RtpReceiver> receivers;

    PeerConnection(long nativePeerConnection, long nativeObserver) {
        this.nativePeerConnection = nativePeerConnection;
        this.nativeObserver = nativeObserver;
        this.localStreams = new LinkedList<MediaStream>();
        this.senders = new LinkedList<RtpSender>();
        this.receivers = new LinkedList<RtpReceiver>();
    }

    public native SessionDescription getLocalDescription();

    public native SessionDescription getRemoteDescription();

    public native DataChannel createDataChannel(String var1, DataChannel.Init var2);

    public native void createOffer(SdpObserver var1, MediaConstraints var2);

    public native void createAnswer(SdpObserver var1, MediaConstraints var2);

    public native void setLocalDescription(SdpObserver var1, SessionDescription var2);

    public native void setRemoteDescription(SdpObserver var1, SessionDescription var2);

    public boolean setConfiguration(RTCConfiguration config) {
        return this.nativeSetConfiguration(config, this.nativeObserver);
    }

    public boolean addIceCandidate(IceCandidate candidate) {
        return this.nativeAddIceCandidate(candidate.sdpMid, candidate.sdpMLineIndex, candidate.sdp);
    }

    public boolean removeIceCandidates(IceCandidate[] candidates) {
        return this.nativeRemoveIceCandidates(candidates);
    }

    public boolean addStream(MediaStream stream) {
        boolean ret = this.nativeAddLocalStream(stream.nativeStream);
        if (!ret) {
            return false;
        }
        this.localStreams.add(stream);
        return true;
    }

    public void removeStream(MediaStream stream) {
        this.nativeRemoveLocalStream(stream.nativeStream);
        this.localStreams.remove(stream);
    }

    public RtpSender createSender(String kind, String stream_id) {
        RtpSender new_sender = this.nativeCreateSender(kind, stream_id);
        if (new_sender != null) {
            this.senders.add(new_sender);
        }
        return new_sender;
    }

    public List<RtpSender> getSenders() {
        for (RtpSender sender : this.senders) {
            sender.dispose();
        }
        this.senders = this.nativeGetSenders();
        return Collections.unmodifiableList(this.senders);
    }

    public List<RtpReceiver> getReceivers() {
        for (RtpReceiver receiver : this.receivers) {
            receiver.dispose();
        }
        this.receivers = this.nativeGetReceivers();
        return Collections.unmodifiableList(this.receivers);
    }

    @Deprecated
    public boolean getStats(StatsObserver observer, MediaStreamTrack track) {
        return this.nativeOldGetStats(observer, track == null ? 0L : track.nativeTrack);
    }

    public void getStats(RTCStatsCollectorCallback callback) {
        this.nativeNewGetStats(callback);
    }

    public native boolean setBitrate(Integer var1, Integer var2, Integer var3);

    public boolean startRtcEventLog(int file_descriptor, int max_size_bytes) {
        return this.nativeStartRtcEventLog(file_descriptor, max_size_bytes);
    }

    public void stopRtcEventLog() {
        this.nativeStopRtcEventLog();
    }

    public native SignalingState signalingState();

    public native IceConnectionState iceConnectionState();

    public native IceGatheringState iceGatheringState();

    public native void close();

    public void dispose() {
        this.close();
        for (MediaStream stream : this.localStreams) {
            this.nativeRemoveLocalStream(stream.nativeStream);
            stream.dispose();
        }
        this.localStreams.clear();
        for (RtpSender sender : this.senders) {
            sender.dispose();
        }
        this.senders.clear();
        for (RtpReceiver receiver : this.receivers) {
            receiver.dispose();
        }
        this.receivers.clear();
        JniCommon.nativeReleaseRef(this.nativePeerConnection);
        PeerConnection.freeObserver(this.nativeObserver);
    }

    private static native void freeObserver(long var0);

    public native boolean nativeSetConfiguration(RTCConfiguration var1, long var2);

    private native boolean nativeAddIceCandidate(String var1, int var2, String var3);

    private native boolean nativeRemoveIceCandidates(IceCandidate[] var1);

    private native boolean nativeAddLocalStream(long var1);

    private native void nativeRemoveLocalStream(long var1);

    private native boolean nativeOldGetStats(StatsObserver var1, long var2);

    private native void nativeNewGetStats(RTCStatsCollectorCallback var1);

    private native RtpSender nativeCreateSender(String var1, String var2);

    private native List<RtpSender> nativeGetSenders();

    private native List<RtpReceiver> nativeGetReceivers();

    private native boolean nativeStartRtcEventLog(int var1, int var2);

    private native void nativeStopRtcEventLog();

    static {
        System.loadLibrary("jingle_peerconnection_so");
    }

    public static class RTCConfiguration {
        public IceTransportsType iceTransportsType = IceTransportsType.ALL;
        public List<IceServer> iceServers;
        public BundlePolicy bundlePolicy = BundlePolicy.BALANCED;
        public RtcpMuxPolicy rtcpMuxPolicy = RtcpMuxPolicy.REQUIRE;
        public TcpCandidatePolicy tcpCandidatePolicy = TcpCandidatePolicy.ENABLED;
        public CandidateNetworkPolicy candidateNetworkPolicy = CandidateNetworkPolicy.ALL;
        public int audioJitterBufferMaxPackets;
        public boolean audioJitterBufferFastAccelerate;
        public int iceConnectionReceivingTimeout;
        public int iceBackupCandidatePairPingInterval;
        public KeyType keyType;
        public ContinualGatheringPolicy continualGatheringPolicy;
        public int iceCandidatePoolSize;
        public boolean pruneTurnPorts;
        public boolean presumeWritableWhenFullyRelayed;
        public Integer iceCheckMinInterval;
        public boolean disableIPv6OnWifi;
        public int maxIPv6Networks;
        public IntervalRange iceRegatherIntervalRange;
        public TurnCustomizer turnCustomizer;

        public RTCConfiguration(List<IceServer> iceServers) {
            this.iceServers = iceServers;
            this.audioJitterBufferMaxPackets = 50;
            this.audioJitterBufferFastAccelerate = false;
            this.iceConnectionReceivingTimeout = -1;
            this.iceBackupCandidatePairPingInterval = -1;
            this.keyType = KeyType.ECDSA;
            this.continualGatheringPolicy = ContinualGatheringPolicy.GATHER_ONCE;
            this.iceCandidatePoolSize = 0;
            this.pruneTurnPorts = false;
            this.presumeWritableWhenFullyRelayed = false;
            this.iceCheckMinInterval = null;
            this.disableIPv6OnWifi = false;
            this.maxIPv6Networks = 5;
            this.iceRegatherIntervalRange = null;
        }
    }

    public static class IntervalRange {
        private final int min;
        private final int max;

        public IntervalRange(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }
    }

    public static enum ContinualGatheringPolicy {
        GATHER_ONCE,
        GATHER_CONTINUALLY;

    }

    public static enum KeyType {
        RSA,
        ECDSA;

    }

    public static enum CandidateNetworkPolicy {
        ALL,
        LOW_COST;

    }

    public static enum TcpCandidatePolicy {
        ENABLED,
        DISABLED;

    }

    public static enum RtcpMuxPolicy {
        NEGOTIATE,
        REQUIRE;

    }

    public static enum BundlePolicy {
        BALANCED,
        MAXBUNDLE,
        MAXCOMPAT;

    }

    public static enum IceTransportsType {
        NONE,
        RELAY,
        NOHOST,
        ALL;

    }

    public static class IceServer {
        @Deprecated
        public final String uri;
        public final List<String> urls;
        public final String username;
        public final String password;
        public final TlsCertPolicy tlsCertPolicy;
        public final String hostname;
        public final List<String> tlsAlpnProtocols;
        public final List<String> tlsEllipticCurves;

        @Deprecated
        public IceServer(String uri) {
            this(uri, "", "");
        }

        @Deprecated
        public IceServer(String uri, String username, String password) {
            this(uri, username, password, TlsCertPolicy.TLS_CERT_POLICY_SECURE);
        }

        @Deprecated
        public IceServer(String uri, String username, String password, TlsCertPolicy tlsCertPolicy) {
            this(uri, username, password, tlsCertPolicy, "");
        }

        @Deprecated
        public IceServer(String uri, String username, String password, TlsCertPolicy tlsCertPolicy, String hostname) {
            this(uri, Collections.singletonList(uri), username, password, tlsCertPolicy, hostname, null, null);
        }

        private IceServer(String uri, List<String> urls, String username, String password, TlsCertPolicy tlsCertPolicy, String hostname, List<String> tlsAlpnProtocols, List<String> tlsEllipticCurves) {
            if (uri == null || urls == null || urls.isEmpty()) {
                throw new IllegalArgumentException("uri == null || urls == null || urls.isEmpty()");
            }
            for (String it : urls) {
                if (it != null) continue;
                throw new IllegalArgumentException("urls element is null: " + urls);
            }
            if (username == null) {
                throw new IllegalArgumentException("username == null");
            }
            if (password == null) {
                throw new IllegalArgumentException("password == null");
            }
            if (hostname == null) {
                throw new IllegalArgumentException("hostname == null");
            }
            this.uri = uri;
            this.urls = urls;
            this.username = username;
            this.password = password;
            this.tlsCertPolicy = tlsCertPolicy;
            this.hostname = hostname;
            this.tlsAlpnProtocols = tlsAlpnProtocols;
            this.tlsEllipticCurves = tlsEllipticCurves;
        }

        public String toString() {
            return this.urls + " [" + this.username + ":" + this.password + "] [" + (Object)((Object)this.tlsCertPolicy) + "] [" + this.hostname + "] [" + this.tlsAlpnProtocols + "] [" + this.tlsEllipticCurves + "]";
        }

        public static Builder builder(String uri) {
            return new Builder(Collections.singletonList(uri));
        }

        public static Builder builder(List<String> urls) {
            return new Builder(urls);
        }

        public static class Builder {
            private final List<String> urls;
            private String username = "";
            private String password = "";
            private TlsCertPolicy tlsCertPolicy = TlsCertPolicy.TLS_CERT_POLICY_SECURE;
            private String hostname = "";
            private List<String> tlsAlpnProtocols;
            private List<String> tlsEllipticCurves;

            private Builder(List<String> urls) {
                if (urls == null || urls.isEmpty()) {
                    throw new IllegalArgumentException("urls == null || urls.isEmpty(): " + urls);
                }
                this.urls = urls;
            }

            public Builder setUsername(String username) {
                this.username = username;
                return this;
            }

            public Builder setPassword(String password) {
                this.password = password;
                return this;
            }

            public Builder setTlsCertPolicy(TlsCertPolicy tlsCertPolicy) {
                this.tlsCertPolicy = tlsCertPolicy;
                return this;
            }

            public Builder setHostname(String hostname) {
                this.hostname = hostname;
                return this;
            }

            public Builder setTlsAlpnProtocols(List<String> tlsAlpnProtocols) {
                this.tlsAlpnProtocols = tlsAlpnProtocols;
                return this;
            }

            public Builder setTlsEllipticCurves(List<String> tlsEllipticCurves) {
                this.tlsEllipticCurves = tlsEllipticCurves;
                return this;
            }

            public IceServer createIceServer() {
                return new IceServer(this.urls.get(0), this.urls, this.username, this.password, this.tlsCertPolicy, this.hostname, this.tlsAlpnProtocols, this.tlsEllipticCurves);
            }
        }
    }

    public static interface Observer {
        public void onSignalingChange(SignalingState var1);

        public void onIceConnectionChange(IceConnectionState var1);

        public void onIceConnectionReceivingChange(boolean var1);

        public void onIceGatheringChange(IceGatheringState var1);

        public void onIceCandidate(IceCandidate var1);

        public void onIceCandidatesRemoved(IceCandidate[] var1);

        public void onAddStream(MediaStream var1);

        public void onRemoveStream(MediaStream var1);

        public void onDataChannel(DataChannel var1);

        public void onRenegotiationNeeded();

        public void onAddTrack(RtpReceiver var1, MediaStream[] var2);
    }

    public static enum SignalingState {
        STABLE,
        HAVE_LOCAL_OFFER,
        HAVE_LOCAL_PRANSWER,
        HAVE_REMOTE_OFFER,
        HAVE_REMOTE_PRANSWER,
        CLOSED;

    }

    public static enum TlsCertPolicy {
        TLS_CERT_POLICY_SECURE,
        TLS_CERT_POLICY_INSECURE_NO_CHECK;

    }

    public static enum IceConnectionState {
        NEW,
        CHECKING,
        CONNECTED,
        COMPLETED,
        FAILED,
        DISCONNECTED,
        CLOSED;

    }

    public static enum IceGatheringState {
        NEW,
        GATHERING,
        COMPLETE;

    }
}

