package org.webrtc;

import android.content.Context;
import android.hardware.camera2.CameraManager;
import android.media.MediaRecorder;

/**
 * Created by kevinleperf on 13/07/2018.
 */

public class FrameEmitterCamera2Capturer extends Camera2Capturer {
    private CameraManager cameraManager;

    public FrameEmitterCamera2Capturer(Context context, String cameraName, CameraEventsHandler eventsHandler) {
        super(context, cameraName, eventsHandler);

        cameraManager = (CameraManager) context.getSystemService(Context.CAMERA_SERVICE);
    }

    @Override
    protected void createCameraSession(CameraSession.CreateSessionCallback createSessionCallback, CameraSession.Events events, Context applicationContext, SurfaceTextureHelper surfaceTextureHelper, MediaRecorder mediaRecoder, String cameraName, int width, int height, int framerate) {
        FrameEmitterCamera2Session.create(createSessionCallback, events, applicationContext, cameraManager,
                surfaceTextureHelper, mediaRecoder, cameraName, width, height, framerate);
    }
}
