package com.voxeet.android.media.peer;

public class SdpDescription {

    private String mType;

    private String mSdp;

    private long mSsrc;

    public SdpDescription(String type, String sdp) {
        //prevent the need for the static and JsonIgnore
        final String SSRC_TAG_KEY = "a=ssrc:";

        mType = type;
        mSdp = sdp;
        mSsrc = 0;

        for (String line : sdp.split("\\r?\\n")) {
            if (line.contains(SSRC_TAG_KEY)) {
                mSsrc = Long.parseLong(line.substring(SSRC_TAG_KEY.length()).split("\\s")[0]);
                break;
            }
        }
    }

    public String getType() {
        return mType;
    }

    public void setType(String type) {
        mType = type;
    }

    public String getSdp() {
        return mSdp;
    }

    public void setSdp(String sdp) {
        mSdp = sdp;
    }

    public long getSsrc() {
        return mSsrc;
    }

    public void setSsrc(long ssrc) {
        mSsrc = ssrc;
    }
}
