/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.android.media.audio;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.support.annotation.NonNull;
import android.util.Log;
import android.view.Window;
import com.voxeet.android.media.audio.AudioRoute;
import com.voxeet.android.media.audio.IMediaStateListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class AudioManager {
    public static final String MEDIA_OUPUT_ROUTE_INTENT = "media-output-route-intent";
    private static final String TAG = AudioManager.class.getSimpleName();
    private Context mContext;
    private boolean isBluetoothScoStarted;
    private android.media.AudioManager mServiceAudioManager;
    private HeadsetStateReceiver mHeadsetStateReceiver;
    private BluetoothHeadset mCurrentBluetoothHeadset;
    private BluetoothHeadsetListener mBluetoothHeadsetListener;
    private BluetoothAdapter mBluetoothAdapter;
    private AudioRoute mOutputRoute = AudioRoute.ROUTE_PHONE;
    private List<IMediaStateListener> mMediaStateListeners;
    private int mSoundType;

    private AudioManager() {
    }

    public AudioManager(Context context) {
        this();
        this.mContext = context;
        this.mMediaStateListeners = new ArrayList<IMediaStateListener>();
        this.mHeadsetStateReceiver = new HeadsetStateReceiver();
        this.mBluetoothHeadsetListener = new BluetoothHeadsetListener();
        this.mCurrentBluetoothHeadset = null;
        this.isBluetoothScoStarted = false;
        this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (this.mBluetoothAdapter != null) {
            this.mBluetoothAdapter.getProfileProxy(context, (BluetoothProfile.ServiceListener)this.mBluetoothHeadsetListener, 1);
        }
        this.mServiceAudioManager = (android.media.AudioManager)context.getSystemService("audio");
        this.mSoundType = this.getUiSoundsStreamType();
        context.registerReceiver((BroadcastReceiver)this.mHeadsetStateReceiver, new IntentFilter("android.intent.action.HEADSET_PLUG"));
    }

    public void stop() {
        this.setBluetooth(false);
        this.mContext.unregisterReceiver((BroadcastReceiver)this.mHeadsetStateReceiver);
        if (this.mCurrentBluetoothHeadset != null && this.mBluetoothAdapter != null) {
            this.mBluetoothAdapter.closeProfileProxy(1, (BluetoothProfile)this.mCurrentBluetoothHeadset);
        }
    }

    public boolean isBluetoothHeadsetOn() {
        return this.mCurrentBluetoothHeadset != null;
    }

    public boolean isWiredHeadsetOn() {
        return this.mServiceAudioManager.isWiredHeadsetOn();
    }

    @NonNull
    public List<AudioRoute> availableRoutes() {
        ArrayList<AudioRoute> routes = new ArrayList<AudioRoute>();
        routes.add(AudioRoute.ROUTE_SPEAKER);
        if (this.isWiredHeadsetOn()) {
            routes.add(AudioRoute.ROUTE_HEADSET);
        } else {
            routes.add(AudioRoute.ROUTE_PHONE);
        }
        if (this.isBluetoothHeadsetOn()) {
            routes.add(AudioRoute.ROUTE_BLUETOOTH);
        }
        return routes;
    }

    @NonNull
    public AudioRoute outputRoute() {
        return this.mOutputRoute;
    }

    public void setOutputRoute(@NonNull AudioRoute route) {
        if (null == route) {
            return;
        }
        switch (route) {
            case ROUTE_HEADSET: 
            case ROUTE_PHONE: {
                this.setSpeakerMode(false);
                break;
            }
            case ROUTE_SPEAKER: {
                this.setSpeakerMode(true);
                break;
            }
            case ROUTE_BLUETOOTH: {
                this.setBluetooth(true);
                break;
            }
        }
    }

    public void setVolumeControlStream(Window window, int streamType) {
        window.setVolumeControlStream(streamType);
    }

    public void setSpeakerPhoneMode(boolean mode) {
        this.mServiceAudioManager.setSpeakerphoneOn(mode);
        if (mode) {
            this.setBluetooth(false);
        }
        this.mServiceAudioManager.setSpeakerphoneOn(mode);
        this.mServiceAudioManager.setMode(0);
        this.forceVolumeControlStream(0);
        this.checkOutputRoute();
    }

    public void setSpeakerMode(boolean speakerMode) {
        this.setBluetooth(false);
        if ("samsung".equalsIgnoreCase(Build.BRAND)) {
            int requiredSpeakerMode = 3;
            if (speakerMode) {
                this.mServiceAudioManager.setSpeakerphoneOn(true);
                this.mServiceAudioManager.setMode(-1);
            } else {
                this.mServiceAudioManager.setSpeakerphoneOn(speakerMode);
                if (this.mServiceAudioManager.isWiredHeadsetOn()) {
                    this.mServiceAudioManager.setMode(-1);
                } else {
                    this.mServiceAudioManager.setMode(requiredSpeakerMode);
                }
            }
        } else {
            this.mServiceAudioManager.setSpeakerphoneOn(speakerMode);
        }
        this.forceVolumeControlStream(0);
        for (IMediaStateListener listeners : this.mMediaStateListeners) {
            listeners.onSpeakerChanged(speakerMode);
        }
        this.checkOutputRoute();
    }

    public void setBluetooth(boolean isEnabled) {
        try {
            if (isEnabled) {
                if (!this.isBluetoothScoStarted) {
                    this.mServiceAudioManager.startBluetoothSco();
                    this.isBluetoothScoStarted = true;
                }
            } else if (this.isBluetoothScoStarted) {
                this.mServiceAudioManager.stopBluetoothSco();
                this.isBluetoothScoStarted = false;
            }
        }
        catch (NullPointerException e) {
            Log.d((String)TAG, (String)"No bluetooth headset connected");
        }
        this.forceVolumeControlStream(0);
        this.checkOutputRoute();
    }

    public void registerMediaState(@NonNull IMediaStateListener listener) {
        if (!this.mMediaStateListeners.contains(listener)) {
            this.mMediaStateListeners.add(listener);
        }
    }

    public void unregisterMediaState(@NonNull IMediaStateListener listener) {
        if (this.mMediaStateListeners.contains(listener)) {
            this.mMediaStateListeners.remove(listener);
        }
    }

    protected void checkOutputRoute() {
        this.mOutputRoute = this.isBluetoothScoStarted ? AudioRoute.ROUTE_BLUETOOTH : (this.mServiceAudioManager.isSpeakerphoneOn() ? AudioRoute.ROUTE_SPEAKER : (this.mServiceAudioManager.isWiredHeadsetOn() ? AudioRoute.ROUTE_HEADSET : AudioRoute.ROUTE_PHONE));
        Intent intent = new Intent(MEDIA_OUPUT_ROUTE_INTENT);
        intent.putExtra("route", this.mOutputRoute.value());
        this.mContext.sendBroadcast(intent);
    }

    public int getDefaultSoundStreamType() {
        return this.mSoundType;
    }

    public void resetDefaultSoundType() {
        if (this.mSoundType >= 0) {
            this.forceVolumeControlStream(this.mSoundType);
        }
    }

    private int getUiSoundsStreamType() {
        try {
            Method method = this.mServiceAudioManager.getClass().getDeclaredMethod("getUiSoundsStreamType", new Class[0]);
            Object result = method.invoke((Object)this.mServiceAudioManager, new Object[0]);
            return (Integer)result;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return 1;
    }

    public void forceVolumeControlStream(int type) {
        try {
            Method method = this.mServiceAudioManager.getClass().getDeclaredMethod("forceVolumeControlStream", Integer.TYPE);
            method.invoke((Object)this.mServiceAudioManager, type);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private class HeadsetStateReceiver
    extends BroadcastReceiver {
        private HeadsetStateReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.HEADSET_PLUG".equals(intent.getAction())) {
                boolean isPlugged;
                int state = intent.getIntExtra("state", -1);
                int has_mic = intent.getIntExtra("microphone", -1);
                boolean bl = isPlugged = state == 1 && has_mic == 1;
                if (isPlugged) {
                    for (IMediaStateListener listeners : AudioManager.this.mMediaStateListeners) {
                        listeners.onHeadsetStateChange(true);
                    }
                    AudioManager.this.setSpeakerMode(false);
                } else {
                    for (IMediaStateListener listeners : AudioManager.this.mMediaStateListeners) {
                        listeners.onHeadsetStateChange(false);
                    }
                    AudioManager.this.setSpeakerMode(true);
                }
            }
        }
    }

    private class BluetoothHeadsetListener
    implements BluetoothProfile.ServiceListener {
        private BluetoothHeadsetListener() {
        }

        public void onServiceConnected(int i, BluetoothProfile bluetoothProfile) {
            AudioManager.this.mCurrentBluetoothHeadset = (BluetoothHeadset)bluetoothProfile;
            for (IMediaStateListener listeners : AudioManager.this.mMediaStateListeners) {
                listeners.onBluetoothHeadsetStateChange(true);
            }
            AudioManager.this.checkOutputRoute();
        }

        public void onServiceDisconnected(int i) {
            AudioManager.this.mCurrentBluetoothHeadset = null;
            for (IMediaStateListener listeners : AudioManager.this.mMediaStateListeners) {
                listeners.onBluetoothHeadsetStateChange(false);
            }
            AudioManager.this.mServiceAudioManager.stopBluetoothSco();
            AudioManager.this.isBluetoothScoStarted = false;
            AudioManager.this.checkOutputRoute();
        }
    }
}

