/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.graphics.Matrix;
import java.nio.ByteBuffer;
import org.webrtc.JavaI420Buffer;
import org.webrtc.RendererCommon;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.VideoFrame;

class TextureBufferImpl
implements VideoFrame.TextureBuffer {
    private final int width;
    private final int height;
    private final VideoFrame.TextureBuffer.Type type;
    private final int id;
    private final Matrix transformMatrix;
    private final SurfaceTextureHelper surfaceTextureHelper;
    private final Runnable releaseCallback;
    private final Object refCountLock = new Object();
    private int refCount;

    public TextureBufferImpl(int width, int height, VideoFrame.TextureBuffer.Type type, int id, Matrix transformMatrix, SurfaceTextureHelper surfaceTextureHelper, Runnable releaseCallback) {
        this.width = width;
        this.height = height;
        this.type = type;
        this.id = id;
        this.transformMatrix = transformMatrix;
        this.surfaceTextureHelper = surfaceTextureHelper;
        this.releaseCallback = releaseCallback;
        this.refCount = 1;
    }

    @Override
    public VideoFrame.TextureBuffer.Type getType() {
        return this.type;
    }

    @Override
    public int getTextureId() {
        return this.id;
    }

    @Override
    public Matrix getTransformMatrix() {
        return this.transformMatrix;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        if (this.type == VideoFrame.TextureBuffer.Type.RGB) {
            throw new RuntimeException("toI420 for RGB frames not implemented yet");
        }
        int stride = (this.width + 7) / 8 * 8;
        int uvHeight = (this.height + 1) / 2;
        int size = stride * (this.height + uvHeight + 1);
        ByteBuffer buffer = ByteBuffer.allocateDirect(size);
        this.surfaceTextureHelper.textureToYUV(buffer, this.width, this.height, stride, this.id, RendererCommon.convertMatrixFromAndroidGraphicsMatrix(this.transformMatrix));
        int yPos = 0;
        int uPos = yPos + stride * this.height;
        int vPos = uPos + stride / 2;
        buffer.position(yPos);
        buffer.limit(yPos + stride * this.height);
        ByteBuffer dataY = buffer.slice();
        buffer.position(uPos);
        buffer.limit(uPos + stride * uvHeight);
        ByteBuffer dataU = buffer.slice();
        buffer.position(vPos);
        buffer.limit(vPos + stride * uvHeight);
        ByteBuffer dataV = buffer.slice();
        return JavaI420Buffer.wrap(this.width, this.height, dataY, stride, dataU, stride, dataV, stride, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retain() {
        Object object = this.refCountLock;
        synchronized (object) {
            ++this.refCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Object object = this.refCountLock;
        synchronized (object) {
            if (--this.refCount == 0 && this.releaseCallback != null) {
                this.releaseCallback.run();
            }
        }
    }

    @Override
    public VideoFrame.Buffer cropAndScale(int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight) {
        this.retain();
        Matrix newMatrix = new Matrix(this.transformMatrix);
        newMatrix.postScale((float)cropWidth / (float)this.width, (float)cropHeight / (float)this.height);
        newMatrix.postTranslate((float)cropX / (float)this.width, (float)cropY / (float)this.height);
        return new TextureBufferImpl(scaleWidth, scaleHeight, this.type, this.id, newMatrix, this.surfaceTextureHelper, new Runnable(){

            @Override
            public void run() {
                TextureBufferImpl.this.release();
            }
        });
    }
}

