/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import org.webrtc.JniCommon;
import org.webrtc.MediaStreamTrack;
import org.webrtc.RtpParameters;

public class RtpReceiver {
    final long nativeRtpReceiver;
    private long nativeObserver;
    private MediaStreamTrack cachedTrack;

    public RtpReceiver(long nativeRtpReceiver) {
        this.nativeRtpReceiver = nativeRtpReceiver;
        long track = RtpReceiver.nativeGetTrack(nativeRtpReceiver);
        this.cachedTrack = new MediaStreamTrack(track);
    }

    public MediaStreamTrack track() {
        return this.cachedTrack;
    }

    public boolean setParameters(RtpParameters parameters) {
        return RtpReceiver.nativeSetParameters(this.nativeRtpReceiver, parameters);
    }

    public RtpParameters getParameters() {
        return RtpReceiver.nativeGetParameters(this.nativeRtpReceiver);
    }

    public String id() {
        return RtpReceiver.nativeId(this.nativeRtpReceiver);
    }

    public void dispose() {
        this.cachedTrack.dispose();
        if (this.nativeObserver != 0L) {
            RtpReceiver.nativeUnsetObserver(this.nativeRtpReceiver, this.nativeObserver);
            this.nativeObserver = 0L;
        }
        JniCommon.nativeReleaseRef(this.nativeRtpReceiver);
    }

    public void SetObserver(Observer observer) {
        if (this.nativeObserver != 0L) {
            RtpReceiver.nativeUnsetObserver(this.nativeRtpReceiver, this.nativeObserver);
        }
        this.nativeObserver = RtpReceiver.nativeSetObserver(this.nativeRtpReceiver, observer);
    }

    private static native long nativeGetTrack(long var0);

    private static native boolean nativeSetParameters(long var0, RtpParameters var2);

    private static native RtpParameters nativeGetParameters(long var0);

    private static native String nativeId(long var0);

    private static native long nativeSetObserver(long var0, Observer var2);

    private static native long nativeUnsetObserver(long var0, long var2);

    public static interface Observer {
        public void onFirstPacketReceived(MediaStreamTrack.MediaType var1);
    }
}

