/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.android.media.video;

import android.content.Context;
import org.webrtc.Camera2Enumerator;
import org.webrtc.CameraVideoCapturer;
import org.webrtc.FrameEmitterCamera2Capturer;

public class CameraEnumerator
extends Camera2Enumerator {
    private final Context mContext;

    public CameraEnumerator(Context context) {
        super(context);
        this.mContext = context;
    }

    public String getNameOfBackFacingDevice() {
        for (String deviceName : this.getDeviceNames()) {
            if (!this.isBackFacing(deviceName)) continue;
            return deviceName;
        }
        return null;
    }

    public String getNameOfFrontFacingDevice() {
        for (String deviceName : this.getDeviceNames()) {
            if (!this.isFrontFacing(deviceName)) continue;
            return deviceName;
        }
        return null;
    }

    @Override
    public CameraVideoCapturer createCapturer(String deviceName, CameraVideoCapturer.CameraEventsHandler eventsHandler) {
        return new FrameEmitterCamera2Capturer(this.mContext, deviceName, eventsHandler);
    }
}

