/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.android.media;

import android.support.annotation.NonNull;
import com.voxeet.android.media.AudioTrack;
import com.voxeet.android.media.VideoTrack;
import java.util.ArrayList;
import java.util.List;

public class MediaStream {
    private String peerId;
    private String label;
    @NonNull
    private List<AudioTrack> audioTrackList = new ArrayList<AudioTrack>();
    @NonNull
    private List<VideoTrack> videoTrackList = new ArrayList<VideoTrack>();

    public MediaStream(String peerId, long nativeMediaStream) {
        this.peerId = peerId;
        this.nativeInitMediaStream(nativeMediaStream);
    }

    private void nativeInitMediaStream(long nativeMediaStream) {
        long[] audioTracks = this.nativeGetAudioTracks(nativeMediaStream);
        long[] videoTracks = this.nativeGetVideoTracks(nativeMediaStream);
        for (long ptr : audioTracks) {
            this.audioTrackList.add(new AudioTrack(ptr));
        }
        for (long ptr : videoTracks) {
            this.videoTrackList.add(new VideoTrack(ptr));
        }
    }

    @NonNull
    public List<AudioTrack> audioTracks() {
        return this.audioTrackList;
    }

    @NonNull
    public List<VideoTrack> videoTracks() {
        return this.videoTrackList;
    }

    public String peerId() {
        return this.peerId;
    }

    public String label() {
        return this.label;
    }

    public void label(String label) {
        this.label = label;
    }

    public Boolean isScreenShare() {
        return false;
    }

    private native long[] nativeGetAudioTracks(long var1);

    private native long[] nativeGetVideoTracks(long var1);
}

