/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.android.media.video;

import android.hardware.Camera;
import android.os.SystemClock;
import android.util.Log;
import com.voxeet.android.media.video.CameraEnumerationAndroid;
import java.util.ArrayList;
import java.util.List;

public class CameraEnumerator
implements CameraEnumerationAndroid.Enumerator {
    private static final String TAG = "CameraEnumerator";
    private List<List<CameraEnumerationAndroid.CaptureFormat>> cachedSupportedFormats;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CameraEnumerationAndroid.CaptureFormat> getSupportedFormats(int cameraId) {
        CameraEnumerator cameraEnumerator = this;
        synchronized (cameraEnumerator) {
            if (this.cachedSupportedFormats == null) {
                this.cachedSupportedFormats = new ArrayList<List<CameraEnumerationAndroid.CaptureFormat>>();
                for (int i = 0; i < CameraEnumerationAndroid.getDeviceCount(); ++i) {
                    this.cachedSupportedFormats.add(this.enumerateFormats(i));
                }
            }
        }
        return this.cachedSupportedFormats.get(cameraId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CameraEnumerationAndroid.CaptureFormat> enumerateFormats(int cameraId) {
        Camera.Parameters parameters;
        Log.d((String)TAG, (String)("Get supported formats for camera index " + cameraId + ""));
        long startTimeMs = SystemClock.elapsedRealtime();
        Camera camera = null;
        try {
            Log.d((String)TAG, (String)("Opening camera with index " + cameraId));
            camera = Camera.open((int)cameraId);
            parameters = camera.getParameters();
        }
        catch (RuntimeException e) {
            Log.e((String)TAG, (String)("Open camera failed on camera index " + cameraId), (Throwable)e);
            ArrayList<CameraEnumerationAndroid.CaptureFormat> arrayList = new ArrayList<CameraEnumerationAndroid.CaptureFormat>();
            return arrayList;
        }
        finally {
            if (camera != null) {
                camera.release();
            }
        }
        ArrayList<CameraEnumerationAndroid.CaptureFormat> formatList = new ArrayList<CameraEnumerationAndroid.CaptureFormat>();
        try {
            int minFps = 0;
            int maxFps = 0;
            List listFpsRange = parameters.getSupportedPreviewFpsRange();
            if (listFpsRange != null) {
                int[] range = (int[])listFpsRange.get(listFpsRange.size() - 1);
                minFps = range[0];
                maxFps = range[1];
            }
            for (Camera.Size size : parameters.getSupportedPreviewSizes()) {
                formatList.add(new CameraEnumerationAndroid.CaptureFormat(size.width, size.height, minFps, maxFps));
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("getSupportedFormats() failed on camera index " + cameraId), (Throwable)e);
        }
        long endTimeMs = SystemClock.elapsedRealtime();
        Log.d((String)TAG, (String)("Get supported formats for camera index " + cameraId + " done. Time spent: " + (endTimeMs - startTimeMs) + " ms."));
        return formatList;
    }
}

