/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.android.media;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.voxeet.android.media.MediaException;
import com.voxeet.android.media.MediaPowerManager;
import com.voxeet.android.media.MediaStream;
import com.voxeet.android.media.Timer;
import com.voxeet.android.media.VideoCapturer;
import com.voxeet.android.media.VideoRenderer;
import com.voxeet.android.media.peer.PendingPeerCallback;
import com.voxeet.android.media.peer.PendingPeerOperation;
import com.voxeet.android.media.peer.SdpCandidate;
import com.voxeet.android.media.peer.SdpCandidates;
import com.voxeet.android.media.peer.SdpDescription;
import com.voxeet.android.media.peer.SdpMessage;
import com.voxeet.android.media.peer.Type;
import com.voxeet.android.media.settings.AudioSettings;
import com.voxeet.android.media.video.CameraEnumerationAndroid;
import com.voxeet.android.media.video.EglBase;
import com.voxeet.android.media.video.EglBase14;
import com.voxeet.android.media.video.VideoCapturerAndroid;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.webrtc.voiceengine.WebRtcAudioUtils;

public class Media {
    public static final String TAG = Media.class.getSimpleName();
    public static final String MEDIA_OUPUT_ROUTE_INTENT = "media-output-route-intent";
    private static AtomicBoolean registered = new AtomicBoolean(false);
    private Handler mHandler;
    private HandlerThread mHandlerThread;
    private VideoCapturerAndroid.CameraSwitchHandler mDefaultCameraSwitchHandler = new VideoCapturerAndroid.CameraSwitchHandler(){

        @Override
        public void onCameraSwitchDone(boolean isFrontCamera) {
            Media.log("onCameraSwitchDone: " + isFrontCamera);
        }

        @Override
        public void onCameraSwitchError(String errorDescription) {
            Media.log("onCameraSwitchError: " + errorDescription);
        }
    };
    private VideoCapturerAndroid.CameraEventsHandler mDefaultCameraHandler = new VideoCapturerAndroid.CameraEventsHandler(){

        @Override
        public void onCameraError(String errorDescription) {
            Media.log("onCameraError: " + errorDescription);
        }

        @Override
        public void onCameraFreezed(String errorDescription) {
            Media.log("onCameraFreezed: " + errorDescription);
        }

        @Override
        public void onCameraOpening(int cameraId) {
            Media.log("onCameraOpening: " + cameraId);
        }

        @Override
        public void onFirstFrameAvailable() {
            Media.log("onFirstFrameAvailable: ");
        }

        @Override
        public void onCameraClosed() {
            Media.log("onCameraClosed: ");
        }
    };
    private HashMap<String, MediaStream> streams;
    private boolean mStopped = false;
    private Object operationLock = new Object();
    private Object candidateLock = new Object();
    private static Context context;
    private AudioManager audioManager;
    private String peer;
    private AudioSettings settings;
    private SdpCandidates peerCandidates;
    private List<PendingPeerOperation> peerOperations;
    private static long sDescriptionTimeout;
    private MediaPowerManager powerManager;
    private MediaStateListener mediaStateListener;
    private MediaStreamListener mediaStreamListener;
    private HeadsetStateReceiver headsetStateReceiver;
    private BluetoothHeadsetListener bluetoothHeadsetListener;
    private BluetoothAdapter bluetoothAdapter;
    private BluetoothHeadset bluetoothHeadset;
    private AudioRoute outputRoute;
    private List<VideoRenderer> renderers;
    private VideoRenderer screenShareVideoRenderer = null;
    private boolean bluetoothScoStarted;
    private boolean isMuted = false;
    private boolean video = false;
    private boolean microphone = false;
    private EglBase eglBase = EglBase14.create();
    private VideoCapturerAndroid videoCapturer = null;

    public static void setDescriptionTimeout(long descriptionTimeout) {
        sDescriptionTimeout = descriptionTimeout;
    }

    public static Context context() {
        return context;
    }

    public Media(Context context) {
        Media.context = context;
    }

    public Media(String peer, Context context, boolean video, boolean microphone, AudioSettings settings) throws MediaException {
        this.streams = new HashMap();
        this.peer = peer;
        this.video = video;
        this.microphone = microphone;
        this.settings = settings;
        this.mediaStateListener = null;
        this.mediaStreamListener = null;
        Media.context = context;
        this.powerManager = new MediaPowerManager(context, this);
        this.headsetStateReceiver = new HeadsetStateReceiver();
        this.bluetoothHeadsetListener = new BluetoothHeadsetListener();
        this.bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        this.bluetoothHeadset = null;
        this.bluetoothScoStarted = false;
        this.powerManager.acquire();
        this.peerOperations = new ArrayList<PendingPeerOperation>();
        this.peerCandidates = new SdpCandidates();
        this.renderers = new ArrayList<VideoRenderer>();
        this.audioManager = (AudioManager)context.getSystemService("audio");
        context.registerReceiver((BroadcastReceiver)this.headsetStateReceiver, new IntentFilter("android.intent.action.HEADSET_PLUG"));
        this.mHandlerThread = new HandlerThread(this.getClass().getSimpleName());
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper());
        this.bluetoothAdapter.getProfileProxy(context, (BluetoothProfile.ServiceListener)this.bluetoothHeadsetListener, 1);
        WebRtcAudioUtils.setDefaultSampleRateHz(16000);
        if (video) {
            this.videoCapturer = VideoCapturerAndroid.create(CameraEnumerationAndroid.getNameOfFrontFacingDevice(), new VideoCapturerAndroid.CameraEventsHandler(){

                @Override
                public void onCameraError(String errorDescription) {
                    Media.log("onCameraError: " + errorDescription);
                }

                @Override
                public void onCameraFreezed(String errorDescription) {
                    Media.log("onCameraFreezed: " + errorDescription);
                }

                @Override
                public void onCameraOpening(int cameraId) {
                    Media.log("onCameraOpening: " + cameraId);
                }

                @Override
                public void onFirstFrameAvailable() {
                    Media.log("onFirstFrameAvailable: ");
                }

                @Override
                public void onCameraClosed() {
                    Media.log("onCameraClosed: ");
                }
            });
        }
        if (!this.Init(peer, this.eglBase.getEglBaseContext(), this.videoCapturer, settings)) {
            throw new MediaException("An error occurred during init");
        }
        if (this.audioManager.isWiredHeadsetOn()) {
            this.setSpeakerMode(false);
        } else {
            this.setSpeakerMode(true);
        }
    }

    public void stop() {
        this.mStopped = true;
        this.setBluetooth(false);
        context.unregisterReceiver((BroadcastReceiver)this.headsetStateReceiver);
        if (this.bluetoothHeadset != null) {
            this.bluetoothAdapter.closeProfileProxy(1, (BluetoothProfile)this.bluetoothHeadset);
        }
        this.powerManager.release();
        if (this.videoCapturer != null) {
            try {
                this.videoCapturer.stopCapture();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.videoCapturer.dispose();
            this.videoCapturer = null;
        }
        this.Release();
        this.audioManager.setSpeakerphoneOn(true);
        this.audioManager.setMode(0);
        try {
            if (Build.VERSION.SDK_INT >= 18) {
                this.mHandlerThread.quitSafely();
            } else {
                this.mHandlerThread.quit();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startVideo() {
        this.startVideo(CameraEnumerationAndroid.getNameOfFrontFacingDevice());
    }

    public void startVideo(String cameraName) {
        if (this.videoCapturer == null) {
            this.videoCapturer = VideoCapturerAndroid.create(cameraName, this.mDefaultCameraHandler);
            this.StartVideo(this.eglBase.getEglBaseContext(), this.videoCapturer);
        }
    }

    public void stopVideo() {
        if (this.videoCapturer != null) {
            this.StopVideo();
            this.videoCapturer = null;
        }
    }

    public void switchCamera(VideoCapturerAndroid.CameraSwitchHandler handler) {
        if (this.videoCapturer != null) {
            this.videoCapturer.switchCamera(handler);
        }
    }

    public void registerListener(MediaStateListener listener) {
        this.mediaStateListener = listener;
    }

    public void unregisterListener() {
        this.mediaStateListener = null;
    }

    public void setMediaStreamListener(MediaStreamListener listener) {
        this.mediaStreamListener = listener;
    }

    public AudioRoute outputRoute() {
        return this.outputRoute;
    }

    public boolean isBluetoothHeadsetOn() {
        return this.bluetoothHeadset != null;
    }

    public boolean isWiredHeadsetOn() {
        return this.audioManager.isWiredHeadsetOn();
    }

    public void setBluetooth(boolean isEnabled) {
        try {
            if (isEnabled) {
                if (!this.bluetoothScoStarted) {
                    this.audioManager.startBluetoothSco();
                    this.bluetoothScoStarted = true;
                }
            } else if (this.bluetoothScoStarted) {
                this.audioManager.stopBluetoothSco();
                this.bluetoothScoStarted = false;
            }
        }
        catch (NullPointerException e) {
            Media.log("No bluetooth headset connected");
        }
        this.checkOutputRoute();
    }

    public void setSpeakerMode(boolean speakerMode) {
        this.setBluetooth(false);
        if (Build.BRAND.equals("Samsung") || Build.BRAND.equals("samsung")) {
            int requiredSpeakerMode = 3;
            if (speakerMode) {
                this.audioManager.setSpeakerphoneOn(true);
                this.audioManager.setMode(-1);
            } else {
                this.audioManager.setSpeakerphoneOn(speakerMode);
                if (this.audioManager.isWiredHeadsetOn()) {
                    this.audioManager.setMode(-1);
                } else {
                    this.audioManager.setMode(requiredSpeakerMode);
                }
            }
        } else {
            this.audioManager.setSpeakerphoneOn(speakerMode);
        }
        if (this.mediaStateListener != null) {
            this.mediaStateListener.OnSpeakerChanged(speakerMode);
        }
        this.checkOutputRoute();
    }

    protected void checkOutputRoute() {
        this.outputRoute = this.bluetoothScoStarted ? AudioRoute.ROUTE_BLUETOOTH : (this.audioManager.isSpeakerphoneOn() ? AudioRoute.ROUTE_SPEAKER : (this.audioManager.isWiredHeadsetOn() ? AudioRoute.ROUTE_HEADSET : AudioRoute.ROUTE_PHONE));
        Intent intent = new Intent(MEDIA_OUPUT_ROUTE_INTENT);
        intent.putExtra("route", this.outputRoute.value());
        context.sendBroadcast(intent);
    }

    public void setOutputRoute(AudioRoute route) {
        switch (route) {
            case ROUTE_HEADSET: 
            case ROUTE_PHONE: {
                this.setSpeakerMode(false);
                break;
            }
            case ROUTE_SPEAKER: {
                this.setSpeakerMode(true);
                break;
            }
            case ROUTE_BLUETOOTH: {
                this.setBluetooth(true);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, MediaStream> getMapOfStreams() {
        Media.log("getMapOfStreams");
        HashMap<String, MediaStream> streams_copy = new HashMap<String, MediaStream>();
        HashMap<String, MediaStream> hashMap = this.streams;
        synchronized (hashMap) {
            for (String key : this.streams.keySet()) {
                streams_copy.put(key, this.streams.get(key));
            }
        }
        return streams_copy;
    }

    public List<AudioRoute> availableRoutes() {
        ArrayList<AudioRoute> routes = new ArrayList<AudioRoute>();
        routes.add(AudioRoute.ROUTE_SPEAKER);
        if (this.isWiredHeadsetOn()) {
            routes.add(AudioRoute.ROUTE_HEADSET);
        } else {
            routes.add(AudioRoute.ROUTE_PHONE);
        }
        if (this.isBluetoothHeadsetOn()) {
            routes.add(AudioRoute.ROUTE_BLUETOOTH);
        }
        return routes;
    }

    public int calibrate(String sound) {
        int delay = this.Calibrate(context, sound);
        return delay;
    }

    public void attachMediaStream(VideoRenderer.Callbacks callbacks, MediaStream stream) {
        Media.log("attachMediaStream " + callbacks + " " + stream);
        VideoRenderer renderer = null;
        for (VideoRenderer r : this.renderers) {
            if (r.callbacks != callbacks) continue;
            renderer = r;
            break;
        }
        if (renderer == null) {
            renderer = new VideoRenderer(callbacks);
            this.renderers.add(renderer);
        }
        if (!this.isStopped()) {
            this.AttachMediaStream(stream.nativeStream, renderer.nativeVideoRenderer);
        }
    }

    public void unattachMediaStream(VideoRenderer.Callbacks callbacks, MediaStream stream) {
        Media.log("unattachMediaStream " + callbacks + " " + stream);
        VideoRenderer renderer = null;
        for (VideoRenderer r : this.renderers) {
            if (r.callbacks != callbacks) continue;
            renderer = r;
            break;
        }
        if (renderer != null && !this.isStopped() && stream != null) {
            this.UnAttachMediaStream(stream.nativeStream, renderer.nativeVideoRenderer);
        }
    }

    public void createOfferForPeer(final String peer, final boolean master, final PendingPeerCallback listener) {
        Media.log("createOfferForPeer " + peer + " " + master + " " + listener);
        if (this.isStopped()) {
            Media.log("stopped");
            return;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (Media.this.isStopped()) {
                        return;
                    }
                    Media.this.createConnection(peer, master);
                    if (!Media.this.isStopped() && !Media.this.CreateOffer(peer)) {
                        throw new MediaException(String.format("Unable to create offer for Peer: %s", peer));
                    }
                    if (!Media.this.isStopped()) {
                        Media.this.WaitForSdpMessage(peer, Type.OFFER, listener);
                    }
                }
                catch (MediaException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void createAnswerForPeer(final String peer, final long ssrc, final SdpDescription offer, final List<SdpCandidate> offerCandidates, final boolean isMaster, final PendingPeerCallback listener) {
        Media.log("createAnswerForPeer " + peer + " " + ssrc + " " + offer.getSdp() + " " + offer.getSsrc() + " " + offer.getSdp() + " " + offerCandidates + " " + isMaster + " " + listener);
        Log.d((String)"SDKMEDIA", (String)("createAnswerForPeer " + peer + " " + ssrc + " " + offer.getSdp() + " " + offer.getSsrc() + " " + offer.getSdp() + " " + offerCandidates + " " + isMaster + " " + listener));
        Media.log("Sending async...");
        if (this.isStopped()) {
            Media.log("stopped");
            return;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    Timer timer = new Timer("SDKMEDIA", "createConnection>>");
                    Media.this.createConnection(peer, isMaster);
                    timer.stop();
                    timer = new Timer("SDKMEDIA", "SetPeerDescription>> " + peer + " " + ssrc + " " + offer.getType() + " " + offer.getSdp() + " " + offer.getSsrc());
                    if (Media.this.isStopped() || !Media.this.SetPeerDescription(peer, ssrc, offer.getType(), offer.getSdp())) {
                        throw new MediaException(String.format("Unable set remote SDP for Peer: %s", peer));
                    }
                    timer.stop();
                    timer = new Timer("SDKMEDIA", "SetPeerCandidate>>");
                    Iterator iterator = offerCandidates.iterator();
                    while (iterator.hasNext()) {
                        SdpCandidate candidate;
                        SdpCandidate c = candidate = (SdpCandidate)iterator.next();
                        Media.this.SetPeerCandidate(peer, c.getSdpMid(), c.getSdpMLineIndex(), c.getSdp());
                    }
                    timer.stop();
                    Media.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (!Media.this.isStopped() && Media.this.CreateAnswer(peer)) {
                                Media.this.WaitForSdpMessage(peer, Type.ANSWER, listener);
                            } else {
                                try {
                                    throw new MediaException(String.format("Unable to create answer for Peer: %s", peer));
                                }
                                catch (MediaException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    });
                }
                catch (MediaException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void addPeerFromAnswer(final String peer, final long ssrc, final SdpDescription answer, final List<SdpCandidate> candidates) throws MediaException {
        if (this.isStopped()) {
            Media.log("stopped");
            return;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                Media.log("addPeerFromAnswer " + peer + " " + ssrc + " " + answer + " " + candidates);
                if (Media.this.isStopped() || !Media.this.SetPeerDescription(peer, ssrc, answer.getType(), answer.getSdp())) {
                    return;
                }
                Media.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (Media.this.isStopped()) {
                            Media.log("stopped");
                            return;
                        }
                        for (SdpCandidate candidate : candidates) {
                            Media.this.SetPeerCandidate(peer, candidate.getSdpMid(), candidate.getSdpMLineIndex(), candidate.getSdp());
                        }
                    }
                });
            }
        });
    }

    public void removePeer(String peer) {
        if (this.isStopped() || !this.ClosePeerConnection(peer)) {
            Log.w((String)TAG, (String)String.format("Unable to close peer connection for peer: %s", peer));
        }
    }

    public void changePeerPosition(String peer, double angle, double distance) {
        if (this.isStopped() || !this.SetPeerPosition(peer, angle, distance)) {
            Log.w((String)TAG, (String)String.format("Unable to change position for peer: %s", peer));
        }
    }

    public void changePeerPosition(String peer, double angle, double distance, float gain) {
        if (this.isStopped() || !this.SetPeerPositionGain(peer, angle, distance, gain)) {
            Log.w((String)TAG, (String)String.format("Unable to change position for peer: %s", peer));
        }
    }

    public void changePeerGain(String peer, float gain) {
        if (this.isStopped() || this.SetPeerGain(peer, gain)) {
            Log.w((String)TAG, (String)String.format("Unable to change gain for peer: {0}", peer));
        }
    }

    public void muteRecording() {
        this.isMuted = true;
        this.SetMute(true);
    }

    public void unMuteRecording() {
        this.isMuted = false;
        this.SetMute(false);
    }

    public boolean isMuted() {
        return this.isMuted;
    }

    public int getLocalVuMeter() {
        return this.GetLocalVuMeter();
    }

    public int getPeerVuMeter(String peer) {
        return this.GetPeerVuMeter(peer);
    }

    public boolean setCodecQuality(int quality) {
        return this.SetCodecQuality(quality);
    }

    public boolean pstnNeeded() {
        return this.PstnNeeded();
    }

    public boolean resetAudioDevice() {
        return this.ResetAudioDevice();
    }

    public void onSessionCreated(String peer, String type, String sdp) {
        Type operationType;
        Media.log("onSessionCreated " + peer + " " + type + " " + sdp);
        if (type.equals("offer")) {
            operationType = Type.OFFER;
        } else if (type.equals("answer")) {
            operationType = Type.ANSWER;
        } else {
            Log.w((String)TAG, (String)String.format("Session description received from an unknown type: %s", type));
            return;
        }
        this.unlockPeerOperation(operationType, peer, new SdpDescription(type, sdp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onIceCandidateDiscovered(String peer, String sdpMid, int sdpMLineIndex, String sdp) {
        Media.log(String.format("onIceCandidateDiscovered ICE candidate discovered for peer: %s with id: %s and SDP: %s", peer, sdpMid, sdp));
        Object object = this.candidateLock;
        synchronized (object) {
            this.peerCandidates.add(peer, new SdpCandidate(sdpMid, sdpMLineIndex, sdp));
        }
        this.onIceComplete(peer);
    }

    public void onIceGatheringComplete(String peer) {
        Media.log(String.format("onIceGatheringComplete ICE candidate gathering complete for peer: %s", peer));
        this.onIceComplete(peer);
    }

    private void onIceComplete(final String peer) {
        if (this.isStopped()) {
            Media.log("stopped");
            return;
        }
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List<SdpCandidate> candidates;
                Iterator iterator = Media.this.candidateLock;
                synchronized (iterator) {
                    candidates = Media.this.peerCandidates.candidates(peer);
                }
                if (candidates.isEmpty()) {
                    Log.w((String)TAG, (String)String.format("No ICE candidate gathered for peer: %s", peer));
                } else {
                    for (PendingPeerOperation operation : Media.this.peerOperations) {
                        if (!operation.getPeer().equals(peer)) continue;
                        Type type = operation.get_type();
                        SdpCandidate candidate = candidates.get(0);
                        Media.this.onSessionCreated(peer, type.toString(), candidate.getSdp());
                        return;
                    }
                }
            }
        });
    }

    public void onStreamAdded(String peer, MediaStream stream) {
        Media.log("Java stream added " + peer + " " + stream);
        if (this.mediaStreamListener != null) {
            this.mediaStreamListener.onStreamAdded(peer, stream);
        }
    }

    public void onStreamUpdated(@NonNull String peer, @NonNull MediaStream stream) {
        Media.log("Java stream updated " + peer + " " + stream);
        if (this.mediaStreamListener != null) {
            this.mediaStreamListener.onStreamUpdated(peer, stream);
        }
    }

    public void onStreamRemoved(@NonNull String peer, @NonNull MediaStream stream) {
        Media.log("Java stream removed " + peer + " " + stream);
        if (this.mediaStreamListener != null) {
            this.mediaStreamListener.onStreamRemoved(peer);
        }
    }

    public void onScreenStreamAdded(@NonNull String peer, @NonNull MediaStream stream) {
        Media.log("onScreenStreamAdded " + peer + " " + stream);
        Media.log("Java screen stream added");
        stream.setIsScreenShare(true);
        if (this.mediaStreamListener != null) {
            this.mediaStreamListener.onScreenStreamAdded(peer, stream);
        }
    }

    public void onScreenStreamRemoved(@NonNull String peer, @NonNull MediaStream stream) {
        Media.log("onScreenStreamRemoved " + peer + " " + stream);
        Media.log("Java stream removed");
        if (this.mediaStreamListener != null) {
            this.mediaStreamListener.onScreenStreamRemoved(peer);
        }
    }

    private void createConnection(@NonNull String peer, boolean master) throws MediaException {
        Media.log("createConnection " + peer + " " + master);
        if (this.isStopped() || !this.CreatePeerConnection(peer, master)) {
            throw new MediaException(String.format("Unable to create connection with Peer: %s", peer));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private PendingPeerOperation createPeerOperation(@NonNull Type type, @NonNull String peer, @NonNull PendingPeerCallback listener) {
        Media.log("createPeerOperation " + (Object)((Object)type) + " " + peer + " " + listener);
        PendingPeerOperation operation = new PendingPeerOperation(type, peer, listener);
        Object object = this.operationLock;
        synchronized (object) {
            if (this.peerOperations.contains(operation)) {
                Log.e((String)TAG, (String)String.format("An operation of type: %s is already pending for peer: %s", type.name(), peer));
                return null;
            }
        }
        this.peerOperations.add(operation);
        return operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockPeerOperation(@NonNull Type type, @NonNull String peer, @NonNull SdpDescription value) {
        Media.log("unlockPeerOperation " + (Object)((Object)type) + " " + peer + " " + value);
        Object object = this.operationLock;
        synchronized (object) {
            boolean isFound = false;
            for (PendingPeerOperation operation : this.peerOperations) {
                if (!operation.tryUnlock(type, peer, value)) continue;
                isFound = true;
                this.peerOperations.remove(operation);
                break;
            }
            if (!isFound) {
                Log.w((String)TAG, (String)String.format("No pending operation found for peer: %s with type: %s", peer, type.name()));
            }
        }
    }

    private void WaitForSdpMessage(final @NonNull String peer, final @NonNull Type type, final @NonNull PendingPeerCallback listener) {
        Media.log("Sending async...");
        if (this.isStopped()) {
            Media.log("stopped");
            return;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                Media.log("waitForSdpMessage " + peer + " " + (Object)((Object)type) + " " + listener);
                PendingPeerOperation descriptionOperation = Media.this.createPeerOperation(type, peer, new PendingPeerCallback(){

                    @Override
                    public void onMessage(SdpMessage message) {
                        if (Media.this.isStopped()) {
                            Media.log("stopped");
                            return;
                        }
                        listener.onMessage(message);
                        Media.log("WaitForSdpMessage: answer obtained after unlock ");
                    }
                });
                if (descriptionOperation != null) {
                    descriptionOperation.waitOperation(sDescriptionTimeout);
                }
            }
        });
    }

    public void MuteConference(boolean shouldMute) {
        if (this.isMuted != shouldMute) {
            this.isMuted = shouldMute;
            this.SetMute(this.isMuted);
        }
    }

    public static void Register(Context context) {
        if (!registered.get()) {
            Media.register(context);
        }
        registered.set(true);
    }

    public static void UnRegister() {
        if (registered.get()) {
            Media.unRegister();
        }
        registered.set(false);
    }

    public static native void register(Context var0);

    public static native void unRegister();

    private native boolean Init(String var1, EglBase.Context var2, VideoCapturer var3, AudioSettings var4);

    private native void Release();

    private native void StartVideo(EglBase.Context var1, VideoCapturer var2);

    private native void StopVideo();

    private native void AttachMediaStream(long var1, long var3);

    private native void UnAttachMediaStream(long var1, long var3);

    private native boolean CreatePeerConnection(String var1, boolean var2);

    private native boolean ClosePeerConnection(String var1);

    private native boolean CreateOffer(String var1);

    private native boolean CreateAnswer(String var1);

    private native boolean SetPeerDescription(String var1, long var2, String var4, String var5);

    private native boolean SetPeerCandidate(String var1, String var2, int var3, String var4);

    private native boolean SetPeerPosition(String var1, double var2, double var4);

    private native boolean SetPeerPositionGain(String var1, double var2, double var4, float var6);

    private native boolean SetPeerGain(String var1, float var2);

    private native void SetMute(boolean var1);

    private native void SetAudioOptions(boolean var1, boolean var2, boolean var3, boolean var4);

    private native int GetLocalVuMeter();

    private native int GetPeerVuMeter(String var1);

    private native boolean SetCodecQuality(int var1);

    private native boolean SetOpusCustomProperties(int var1, int var2);

    private native boolean DecreasePeersQuality();

    private native boolean PstnNeeded();

    public native int Calibrate(Context var1, String var2);

    public native boolean ResetAudioDevice();

    private static void log(String value) {
        Log.d((String)TAG, (String)("log: " + value));
    }

    private boolean isStopped() {
        return this.mStopped;
    }

    static {
        sDescriptionTimeout = 2000L;
        try {
            System.loadLibrary("media-jni");
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.getMessage());
        }
        catch (UnsatisfiedLinkError e) {
            Media.log("unsupported device architecture");
            Log.e((String)TAG, (String)e.getMessage());
        }
    }

    private class BluetoothHeadsetListener
    implements BluetoothProfile.ServiceListener {
        private BluetoothHeadsetListener() {
        }

        public void onServiceConnected(int i, BluetoothProfile bluetoothProfile) {
            Media.this.bluetoothHeadset = (BluetoothHeadset)bluetoothProfile;
            if (Media.this.mediaStateListener != null) {
                Media.this.mediaStateListener.onBluetoothHeadsetStateChange(true);
            }
        }

        public void onServiceDisconnected(int i) {
            Media.this.bluetoothHeadset = null;
            if (Media.this.mediaStateListener != null) {
                Media.this.mediaStateListener.onBluetoothHeadsetStateChange(false);
                Media.this.audioManager.stopBluetoothSco();
                Media.this.bluetoothScoStarted = false;
            }
            Media.this.checkOutputRoute();
        }
    }

    private class BluetoothStateReceiver
    extends BroadcastReceiver {
        private BluetoothStateReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if ("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED".equals(intent.getAction()) && Media.this.mediaStateListener != null) {
                int state = intent.getIntExtra("android.bluetooth.profile.extra.STATE", -1);
                switch (state) {
                    case 0: {
                        Media.this.mediaStateListener.onBluetoothHeadsetStateChange(false);
                        break;
                    }
                    case 2: {
                        Media.this.mediaStateListener.onBluetoothHeadsetStateChange(true);
                        break;
                    }
                }
            }
        }
    }

    private class HeadsetStateReceiver
    extends BroadcastReceiver {
        private HeadsetStateReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.HEADSET_PLUG".equals(intent.getAction())) {
                int state = intent.getIntExtra("state", -1);
                switch (state) {
                    case 0: {
                        if (Media.this.mediaStateListener != null) {
                            Media.this.mediaStateListener.onHeadsetStateChange(false);
                        }
                        Media.this.setSpeakerMode(true);
                        break;
                    }
                    case 1: {
                        if (Media.this.mediaStateListener != null) {
                            Media.this.mediaStateListener.onHeadsetStateChange(true);
                        }
                        Media.this.setSpeakerMode(false);
                        break;
                    }
                }
            }
        }
    }

    public static interface MediaStreamListener {
        public void onStreamAdded(String var1, MediaStream var2);

        public void onStreamUpdated(String var1, MediaStream var2);

        public void onStreamRemoved(String var1);

        public void onScreenStreamAdded(String var1, MediaStream var2);

        public void onScreenStreamRemoved(String var1);
    }

    public static interface MediaStateListener {
        public void OnSpeakerChanged(boolean var1);

        public void onHeadsetStateChange(boolean var1);

        public void onBluetoothHeadsetStateChange(boolean var1);
    }

    public static enum AudioRoute {
        ROUTE_HEADSET(0),
        ROUTE_PHONE(1),
        ROUTE_SPEAKER(2),
        ROUTE_BLUETOOTH(3);

        private int value;

        private AudioRoute(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public static AudioRoute valueOf(int value) {
            switch (value) {
                case 0: {
                    return ROUTE_HEADSET;
                }
                case 1: {
                    return ROUTE_PHONE;
                }
                case 2: {
                    return ROUTE_SPEAKER;
                }
                case 3: {
                    return ROUTE_BLUETOOTH;
                }
            }
            return ROUTE_SPEAKER;
        }
    }
}

