package com.voxeet.android.media.peer;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public class SdpDescription {

    @JsonIgnore
	private final String SSRC_TAG_KEY = "a=ssrc:";

    @JsonProperty("type")
    private String type;

    @JsonProperty("sdp")
    private String sdp;

    @JsonProperty("ssrc")
    private long ssrc;
    
    public SdpDescription(String type, String sdp){
    	this.type = type;
    	this.sdp = sdp;
        this.ssrc = 0;
    	
    	for (String line : sdp.split("\\r?\\n")){
    		if (line.contains(SSRC_TAG_KEY)){
    			ssrc = Long.parseLong(line.substring(SSRC_TAG_KEY.length()).split("\\s")[0]);
                break;
    		}
    	}
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSdp() {
        return sdp;
    }

    public void setSdp(String sdp) {
        this.sdp = sdp;
    }

    public long getSsrc() {
        return ssrc;
    }

    public void setSsrc(long ssrc) {
        this.ssrc = ssrc;
    }
}
