package com.voxeet.android.media.peer;

import android.support.annotation.NonNull;

import java.util.HashMap;

/**
 * Created by kevinleperf on 04/04/2018.
 */

public class PeerThreadController {

    private HashMap<String, PeerThread> mThreads;

    private PeerThreadController() {
        mThreads = new HashMap<>();
    }

    public static PeerThreadController newInstance(){
        return new PeerThreadController();
    }

    public PeerThread getForPeer(@NonNull String peer) {
        if(mThreads.containsKey(peer)) {
            return mThreads.get(peer);
        }
        PeerThread thread = new PeerThread(peer);
        thread.start();
        mThreads.put(peer, thread);
        return thread;
    }

    public void stop() {
        try {
            for (String peer : mThreads.keySet()) {
                mThreads.get(peer).stop();
            }
        } catch (Exception e){
            e.printStackTrace();
        }
    }
}
