package com.voxeet.android.media.peer;

import android.os.Handler;
import android.os.HandlerThread;
import android.support.annotation.NonNull;

/**
 * Created by kevinleperf on 04/04/2018.
 */

public class PeerThread {

    private String mPeer;
    private Handler mHandler;
    private HandlerThread mHandlerThread;

    private PeerThread() {

    }

    public PeerThread(String peer) {
        this();
        mPeer = peer;
    }

    public void post(@NonNull Runnable runnable) {
        mHandler.post(runnable);
    }

    public void postDelayed(@NonNull Runnable runnable, long delay) {
        mHandler.postDelayed(runnable, delay);
    }

    public void stop() {
        try {
            mHandlerThread.quit();
        } catch (Exception e) {

        }
    }

    public void start() {
        if (mHandler == null) {
            mHandlerThread = new HandlerThread(mPeer);
            mHandlerThread.start();
            mHandler = new Handler(mHandlerThread.getLooper());
        }
    }
}
