/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.voiceengine;

import android.content.Context;
import android.media.AudioRecord;
import android.os.Process;
import android.util.Log;
import java.nio.ByteBuffer;
import org.webrtc.voiceengine.WebRtcAudioEffects;
import org.webrtc.voiceengine.WebRtcAudioManager;
import org.webrtc.voiceengine.WebRtcAudioUtils;

class WebRtcAudioRecord {
    private static final boolean DEBUG = false;
    private static final String TAG = "WebRtcAudioRecord";
    private static final int BITS_PER_SAMPLE = 16;
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final int BUFFERS_PER_SECOND = 100;
    private static final int BUFFER_SIZE_FACTOR = 2;
    private final long nativeAudioRecord;
    private final Context context;
    private WebRtcAudioEffects effects = null;
    private ByteBuffer byteBuffer;
    private AudioRecord audioRecord = null;
    private AudioRecordThread audioThread = null;

    WebRtcAudioRecord(Context context, long nativeAudioRecord) {
        Log.d((String)TAG, (String)("ctor" + WebRtcAudioUtils.getThreadInfo()));
        this.context = context;
        this.nativeAudioRecord = nativeAudioRecord;
        this.effects = WebRtcAudioEffects.create();
    }

    private boolean enableBuiltInAEC(boolean enable) {
        Log.d((String)TAG, (String)("enableBuiltInAEC(" + enable + ')'));
        if (this.effects == null) {
            Log.e((String)TAG, (String)"Built-in AEC is not supported on this platform");
            return false;
        }
        return this.effects.setAEC(enable);
    }

    private boolean enableBuiltInAGC(boolean enable) {
        Log.d((String)TAG, (String)("enableBuiltInAGC(" + enable + ')'));
        if (this.effects == null) {
            Log.e((String)TAG, (String)"Built-in AGC is not supported on this platform");
            return false;
        }
        return this.effects.setAGC(enable);
    }

    private boolean enableBuiltInNS(boolean enable) {
        Log.d((String)TAG, (String)("enableBuiltInNS(" + enable + ')'));
        if (this.effects == null) {
            Log.e((String)TAG, (String)"Built-in NS is not supported on this platform");
            return false;
        }
        return this.effects.setNS(enable);
    }

    private int initRecording(int sampleRate, int channels) {
        int audioSource;
        Log.d((String)TAG, (String)("initRecording(sampleRate=" + sampleRate + ", channels=" + channels + ")"));
        if (!WebRtcAudioUtils.hasPermission(this.context, "android.permission.RECORD_AUDIO")) {
            Log.e((String)TAG, (String)"RECORD_AUDIO permission is missing");
            return -1;
        }
        if (this.audioRecord != null) {
            Log.e((String)TAG, (String)"InitRecording() called twice without StopRecording()");
            return -1;
        }
        int bytesPerFrame = channels * 2;
        int framesPerBuffer = sampleRate / 100;
        this.byteBuffer = ByteBuffer.allocateDirect(bytesPerFrame * framesPerBuffer);
        Log.d((String)TAG, (String)("byteBuffer.capacity: " + this.byteBuffer.capacity()));
        this.nativeCacheDirectBufferAddress(this.byteBuffer, this.nativeAudioRecord);
        int minBufferSize = AudioRecord.getMinBufferSize((int)sampleRate, (int)(channels == 1 ? 16 : 12), (int)2) * 2;
        if (minBufferSize == -1 || minBufferSize == -2) {
            Log.e((String)TAG, (String)("AudioRecord.getMinBufferSize failed: " + minBufferSize));
            return -1;
        }
        Log.d((String)TAG, (String)("AudioRecord.getMinBufferSize: " + minBufferSize));
        int bufferSizeInBytes = Math.max(2 * minBufferSize, this.byteBuffer.capacity());
        Log.d((String)TAG, (String)("bufferSizeInBytes: " + bufferSizeInBytes));
        int n = audioSource = WebRtcAudioManager.ISAndroidVoiceCall() ? 4 : 7;
        if (!this.context.getPackageManager().hasSystemFeature("android.hardware.telephony")) {
            audioSource = 2;
        }
        try {
            this.audioRecord = new AudioRecord(audioSource, sampleRate, channels == 1 ? 16 : 12, 2, bufferSizeInBytes);
        }
        catch (IllegalArgumentException e) {
            Log.e((String)TAG, (String)e.getMessage());
            return -1;
        }
        if (this.audioRecord == null || this.audioRecord.getState() != 1) {
            Log.e((String)TAG, (String)"Failed to create a new AudioRecord instance");
            return -1;
        }
        Log.d((String)TAG, (String)("AudioRecord session ID: " + this.audioRecord.getAudioSessionId() + ", audio format: " + this.audioRecord.getAudioFormat() + ", channels: " + this.audioRecord.getChannelCount() + ", sample rate: " + this.audioRecord.getSampleRate()));
        if (this.effects != null) {
            this.effects.enable(this.audioRecord.getAudioSessionId());
        }
        return framesPerBuffer;
    }

    private boolean startRecording() {
        Log.d((String)TAG, (String)"startRecording");
        WebRtcAudioRecord.assertTrue(this.audioRecord != null);
        WebRtcAudioRecord.assertTrue(this.audioThread == null);
        try {
            this.audioRecord.startRecording();
        }
        catch (IllegalStateException e) {
            Log.e((String)TAG, (String)("AudioRecord.startRecording failed: " + e.getMessage()));
            return false;
        }
        if (this.audioRecord.getRecordingState() != 3) {
            Log.e((String)TAG, (String)"AudioRecord.startRecording failed");
            return false;
        }
        this.audioThread = new AudioRecordThread("AudioRecordJavaThread");
        this.audioThread.start();
        return true;
    }

    private boolean stopRecording() {
        Log.d((String)TAG, (String)"stopRecording");
        WebRtcAudioRecord.assertTrue(this.audioThread != null);
        this.audioThread.joinThread();
        this.audioThread = null;
        if (this.effects != null) {
            this.effects.release();
        }
        this.audioRecord.release();
        this.audioRecord = null;
        return true;
    }

    private static void assertTrue(boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    private native void nativeCacheDirectBufferAddress(ByteBuffer var1, long var2);

    private native void nativeDataIsRecorded(int var1, long var2);

    private class AudioRecordThread
    extends Thread {
        private volatile boolean keepAlive;

        public AudioRecordThread(String name) {
            super(name);
            this.keepAlive = true;
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)-19);
            Log.d((String)WebRtcAudioRecord.TAG, (String)("AudioRecordThread" + WebRtcAudioUtils.getThreadInfo()));
            WebRtcAudioRecord.assertTrue(WebRtcAudioRecord.this.audioRecord.getRecordingState() == 3);
            long lastTime = System.nanoTime();
            while (this.keepAlive) {
                int bytesRead = WebRtcAudioRecord.this.audioRecord.read(WebRtcAudioRecord.this.byteBuffer, WebRtcAudioRecord.this.byteBuffer.capacity());
                if (bytesRead == WebRtcAudioRecord.this.byteBuffer.capacity()) {
                    WebRtcAudioRecord.this.nativeDataIsRecorded(bytesRead, WebRtcAudioRecord.this.nativeAudioRecord);
                    continue;
                }
                Log.e((String)WebRtcAudioRecord.TAG, (String)("AudioRecord.read failed: " + bytesRead));
                if (bytesRead != -3) continue;
                this.keepAlive = false;
            }
            try {
                WebRtcAudioRecord.this.audioRecord.stop();
            }
            catch (IllegalStateException e) {
                Log.e((String)WebRtcAudioRecord.TAG, (String)("AudioRecord.stop failed: " + e.getMessage()));
            }
        }

        public void joinThread() {
            this.keepAlive = false;
            while (this.isAlive()) {
                try {
                    this.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

