/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.android.media.peer;

import android.os.Handler;
import android.support.annotation.NonNull;
import android.util.Log;
import com.voxeet.android.media.Media;
import com.voxeet.android.media.peer.PendingPeerCallback;
import com.voxeet.android.media.peer.SdpDescription;
import com.voxeet.android.media.peer.SdpMessage;
import com.voxeet.android.media.peer.Type;
import java.util.Collections;

public class PendingPeerOperation {
    private Handler _handler;
    private String _peer;
    private Type _type;
    private SdpDescription _value;
    private PendingPeerCallback _listener;

    public PendingPeerOperation(@NonNull Type type, @NonNull String peer, @NonNull PendingPeerCallback listener) {
        this._type = type;
        this._peer = peer;
        this._listener = listener;
        this._handler = new Handler();
    }

    public void waitOperation(long timeout) {
        this._handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (PendingPeerOperation.this._listener != null && PendingPeerOperation.this._value == null) {
                    PendingPeerOperation.this.onMessage();
                    Log.d((String)Media.TAG, (String)String.format(PendingPeerOperation.this._type.name(), PendingPeerOperation.this._peer));
                }
            }
        }, timeout);
    }

    public boolean tryUnlock(@NonNull Type type, @NonNull String peer, @NonNull SdpDescription value) {
        if (this._type != type || !this._peer.equals(peer)) {
            return false;
        }
        this._value = value;
        this.onMessage();
        return true;
    }

    private boolean equals(PendingPeerOperation operation) {
        if (operation == this) {
            return true;
        }
        return this._type == operation._type && this._peer == operation._peer;
    }

    public boolean equals(Object value) {
        if (value != null && value instanceof PendingPeerOperation) {
            return this.equals((PendingPeerOperation)value);
        }
        return false;
    }

    public int hashCode() {
        return this._type.value() * 397 ^ (this._peer != null ? this._peer.hashCode() : 0);
    }

    @NonNull
    public Type get_type() {
        return this._type;
    }

    @NonNull
    public String getPeer() {
        return this._peer;
    }

    private void onMessage() {
        if (this._listener != null) {
            this._listener.onMessage(new SdpMessage(this._value, Collections.emptyList()));
            this._listener = null;
        }
    }
}

