package com.voxeet.android.media.peer;

import android.os.Handler;
import android.support.annotation.NonNull;
import android.util.Log;

import com.voxeet.android.media.MediaException;

import java.util.Collections;

import static com.voxeet.android.media.Media.TAG;

/**
 * Deprecated behaviour : the current is waiting on the main thread !
 * working on implementing a non blocking wait behaviour
 * <p>
 * first iteration : generic instead of Object
 */
public class PendingPeerOperation {
    private Handler _handler;

    private String _peer;
    private Type _type;

    private SdpDescription _value;
    private PendingPeerCallback _listener;

    public PendingPeerOperation(@NonNull Type type,
                                @NonNull String peer,
                                @NonNull PendingPeerCallback listener) {
        _type = type;
        _peer = peer;
        _listener = listener;
        _handler = new Handler();
    }

    public void waitOperation(long timeout) {
        _handler.postDelayed(new Runnable() {
            @Override
            public void run() {
                if (_listener != null && _value == null) {
                    //_value still is null
                    onMessage();

                    Log.d(TAG, "run: Timeout reached while waiting for operation: %s for _peer: %s".format(_type.name(), _peer));
                }
            }
        }, timeout);
    }

    public boolean tryUnlock(@NonNull Type type, @NonNull String peer, @NonNull SdpDescription value) {
        if (this._type != type || !this._peer.equals(peer)) {
            return false;
        }

        this._value = value;
        //handle.countDown();

        onMessage();

        return true;
    }

    private boolean equals(PendingPeerOperation operation) {
        if (operation == this) {
            return true;
        }

        if (this._type == operation._type && this._peer == operation._peer) {
            return true;
        }

        return false;
    }

    @Override
    public boolean equals(Object value) {
        if (value != null) {
            if (value instanceof PendingPeerOperation) {
                return equals((PendingPeerOperation) value);
            }
        }

        return false;
    }

    @Override
    public int hashCode() {
        return (_type.value() * 397) ^ (_peer != null ? _peer.hashCode() : 0);
    }

    @NonNull
    public Type get_type() {
        return _type;
    }

    @NonNull
    public String getPeer() {
        return _peer;
    }


    private void onMessage() {
        if (_listener != null) {
            _listener.onMessage(new SdpMessage(this._value, Collections.<SdpCandidate>emptyList()));
            _listener = null;
        }
    }
}
