/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.android.media.video;

import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.SystemClock;
import android.util.Log;
import com.voxeet.android.media.video.EglBase;
import com.voxeet.android.media.video.GlShader;
import com.voxeet.android.media.video.GlUtil;
import com.voxeet.android.media.video.RendererCommon;
import com.voxeet.android.media.video.ThreadUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class SurfaceTextureHelper {
    private static final String TAG = "SurfaceTextureHelper";
    private final Handler handler;
    private final EglBase eglBase;
    private final SurfaceTexture surfaceTexture;
    private final int oesTextureId;
    private YuvConverter yuvConverter;
    private OnTextureFrameAvailableListener listener;
    private boolean hasPendingTexture = false;
    private volatile boolean isTextureInUse = false;
    private boolean isQuitting = false;
    private OnTextureFrameAvailableListener pendingListener;
    final Runnable setListenerRunnable = new Runnable(){

        @Override
        public void run() {
            Log.d((String)SurfaceTextureHelper.TAG, (String)("Setting listener to " + SurfaceTextureHelper.this.pendingListener));
            SurfaceTextureHelper.this.listener = SurfaceTextureHelper.this.pendingListener;
            SurfaceTextureHelper.this.pendingListener = null;
            SurfaceTextureHelper.this.tryDeliverTextureFrame();
        }
    };

    public static SurfaceTextureHelper create(final String threadName, final EglBase.Context sharedContext) {
        HandlerThread thread = new HandlerThread(threadName);
        thread.start();
        final Handler handler = new Handler(thread.getLooper());
        return ThreadUtils.invokeUninterruptibly(handler, new Callable<SurfaceTextureHelper>(){

            @Override
            public SurfaceTextureHelper call() {
                try {
                    return new SurfaceTextureHelper(sharedContext, handler);
                }
                catch (RuntimeException e) {
                    Log.e((String)SurfaceTextureHelper.TAG, (String)(threadName + " create failure"), (Throwable)e);
                    return null;
                }
            }
        });
    }

    private SurfaceTextureHelper(EglBase.Context sharedContext, Handler handler) {
        if (handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("SurfaceTextureHelper must be created on the handler thread");
        }
        this.handler = handler;
        this.eglBase = EglBase.create(sharedContext, EglBase.CONFIG_PIXEL_BUFFER);
        try {
            this.eglBase.createDummyPbufferSurface();
            this.eglBase.makeCurrent();
        }
        catch (RuntimeException e) {
            this.eglBase.release();
            handler.getLooper().quit();
            throw e;
        }
        this.oesTextureId = GlUtil.generateTexture(36197);
        this.surfaceTexture = new SurfaceTexture(this.oesTextureId);
        this.surfaceTexture.setOnFrameAvailableListener(new SurfaceTexture.OnFrameAvailableListener(){

            public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                SurfaceTextureHelper.this.hasPendingTexture = true;
                SurfaceTextureHelper.this.tryDeliverTextureFrame();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private YuvConverter getYuvConverter() {
        if (this.yuvConverter != null) {
            return this.yuvConverter;
        }
        SurfaceTextureHelper surfaceTextureHelper = this;
        synchronized (surfaceTextureHelper) {
            if (this.yuvConverter == null) {
                this.yuvConverter = new YuvConverter(this.eglBase.getEglBaseContext());
            }
            return this.yuvConverter;
        }
    }

    public void startListening(OnTextureFrameAvailableListener listener) {
        if (this.listener != null || this.pendingListener != null) {
            throw new IllegalStateException("SurfaceTextureHelper listener has already been set.");
        }
        this.pendingListener = listener;
        this.handler.post(this.setListenerRunnable);
    }

    public void stopListening() {
        if (this.handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("Wrong thread.");
        }
        Log.d((String)TAG, (String)"stopListening()");
        this.handler.removeCallbacks(this.setListenerRunnable);
        this.listener = null;
        this.pendingListener = null;
    }

    public SurfaceTexture getSurfaceTexture() {
        return this.surfaceTexture;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void returnTextureFrame() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                SurfaceTextureHelper.this.isTextureInUse = false;
                if (SurfaceTextureHelper.this.isQuitting) {
                    SurfaceTextureHelper.this.release();
                } else {
                    SurfaceTextureHelper.this.tryDeliverTextureFrame();
                }
            }
        });
    }

    public boolean isTextureInUse() {
        return this.isTextureInUse;
    }

    public void dispose() {
        Log.d((String)TAG, (String)"dispose()");
        if (this.handler.getLooper().getThread() == Thread.currentThread()) {
            this.isQuitting = true;
            if (!this.isTextureInUse) {
                this.release();
            }
            return;
        }
        final CountDownLatch barrier = new CountDownLatch(1);
        this.handler.postAtFrontOfQueue(new Runnable(){

            @Override
            public void run() {
                SurfaceTextureHelper.this.isQuitting = true;
                barrier.countDown();
                if (!SurfaceTextureHelper.this.isTextureInUse) {
                    SurfaceTextureHelper.this.release();
                }
            }
        });
        ThreadUtils.awaitUninterruptibly(barrier);
    }

    public void textureToYUV(ByteBuffer buf, int width, int height, int stride, int textureId, float[] transformMatrix) {
        if (textureId != this.oesTextureId) {
            throw new IllegalStateException("textureToByteBuffer called with unexpected textureId");
        }
        this.getYuvConverter().convert(buf, width, height, stride, textureId, transformMatrix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryDeliverTextureFrame() {
        if (this.handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("Wrong thread.");
        }
        if (this.isQuitting || !this.hasPendingTexture || this.isTextureInUse || this.listener == null) {
            return;
        }
        this.isTextureInUse = true;
        this.hasPendingTexture = false;
        Object object = EglBase.lock;
        synchronized (object) {
            this.surfaceTexture.updateTexImage();
        }
        float[] transformMatrix = new float[16];
        this.surfaceTexture.getTransformMatrix(transformMatrix);
        long timestampNs = Build.VERSION.SDK_INT >= 14 ? this.surfaceTexture.getTimestamp() : TimeUnit.MILLISECONDS.toNanos(SystemClock.elapsedRealtime());
        this.listener.onTextureFrameAvailable(this.oesTextureId, transformMatrix, timestampNs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release() {
        if (this.handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("Wrong thread.");
        }
        if (this.isTextureInUse || !this.isQuitting) {
            throw new IllegalStateException("Unexpected release.");
        }
        SurfaceTextureHelper surfaceTextureHelper = this;
        synchronized (surfaceTextureHelper) {
            if (this.yuvConverter != null) {
                this.yuvConverter.release();
            }
        }
        GLES20.glDeleteTextures((int)1, (int[])new int[]{this.oesTextureId}, (int)0);
        this.surfaceTexture.release();
        this.eglBase.release();
        this.handler.getLooper().quit();
    }

    private static class YuvConverter {
        private final EglBase eglBase;
        private final GlShader shader;
        private boolean released = false;
        private static final FloatBuffer DEVICE_RECTANGLE = GlUtil.createFloatBuffer(new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f});
        private static final FloatBuffer TEXTURE_RECTANGLE = GlUtil.createFloatBuffer(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f});
        private static final String VERTEX_SHADER = "varying vec2 interp_tc;\nattribute vec4 in_pos;\nattribute vec4 in_tc;\n\nuniform mat4 texMatrix;\n\nvoid main() {\n    gl_Position = in_pos;\n    interp_tc = (texMatrix * in_tc).xy;\n}\n";
        private static final String FRAGMENT_SHADER = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 interp_tc;\n\nuniform samplerExternalOES oesTex;\nuniform vec2 xUnit;\nuniform vec4 coeffs;\n\nvoid main() {\n  gl_FragColor.r = coeffs.a + dot(coeffs.rgb,\n      texture2D(oesTex, interp_tc - 1.5 * xUnit).rgb);\n  gl_FragColor.g = coeffs.a + dot(coeffs.rgb,\n      texture2D(oesTex, interp_tc - 0.5 * xUnit).rgb);\n  gl_FragColor.b = coeffs.a + dot(coeffs.rgb,\n      texture2D(oesTex, interp_tc + 0.5 * xUnit).rgb);\n  gl_FragColor.a = coeffs.a + dot(coeffs.rgb,\n      texture2D(oesTex, interp_tc + 1.5 * xUnit).rgb);\n}\n";
        private int texMatrixLoc;
        private int xUnitLoc;
        private int coeffsLoc;

        YuvConverter(EglBase.Context sharedContext) {
            this.eglBase = EglBase.create(sharedContext, EglBase.CONFIG_PIXEL_RGBA_BUFFER);
            this.eglBase.createDummyPbufferSurface();
            this.eglBase.makeCurrent();
            this.shader = new GlShader(VERTEX_SHADER, FRAGMENT_SHADER);
            this.shader.useProgram();
            this.texMatrixLoc = this.shader.getUniformLocation("texMatrix");
            this.xUnitLoc = this.shader.getUniformLocation("xUnit");
            this.coeffsLoc = this.shader.getUniformLocation("coeffs");
            GLES20.glUniform1i((int)this.shader.getUniformLocation("oesTex"), (int)0);
            GlUtil.checkNoGLES2Error("Initialize fragment shader uniform values.");
            this.shader.setVertexAttribArray("in_pos", 2, DEVICE_RECTANGLE);
            this.shader.setVertexAttribArray("in_tc", 2, TEXTURE_RECTANGLE);
            this.eglBase.detachCurrent();
        }

        synchronized void convert(ByteBuffer buf, int width, int height, int stride, int textureId, float[] transformMatrix) {
            if (this.released) {
                throw new IllegalStateException("YuvConverter.convert called on released object");
            }
            if (stride % 8 != 0) {
                throw new IllegalArgumentException("Invalid stride, must be a multiple of 8");
            }
            if (stride < width) {
                throw new IllegalArgumentException("Invalid stride, must >= width");
            }
            int y_width = (width + 3) / 4;
            int uv_width = (width + 7) / 8;
            int uv_height = (height + 1) / 2;
            int total_height = height + uv_height;
            int size = stride * total_height;
            if (buf.capacity() < size) {
                throw new IllegalArgumentException("YuvConverter.convert called with too small buffer");
            }
            transformMatrix = RendererCommon.multiplyMatrices(transformMatrix, RendererCommon.verticalFlipMatrix());
            if (this.eglBase.hasSurface()) {
                if (this.eglBase.surfaceWidth() != stride / 4 || this.eglBase.surfaceHeight() != total_height) {
                    this.eglBase.releaseSurface();
                    this.eglBase.createPbufferSurface(stride / 4, total_height);
                }
            } else {
                this.eglBase.createPbufferSurface(stride / 4, total_height);
            }
            this.eglBase.makeCurrent();
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)36197, (int)textureId);
            GLES20.glUniformMatrix4fv((int)this.texMatrixLoc, (int)1, (boolean)false, (float[])transformMatrix, (int)0);
            GLES20.glViewport((int)0, (int)0, (int)y_width, (int)height);
            GLES20.glUniform2f((int)this.xUnitLoc, (float)(transformMatrix[0] / (float)width), (float)(transformMatrix[1] / (float)width));
            GLES20.glUniform4f((int)this.coeffsLoc, (float)0.299f, (float)0.587f, (float)0.114f, (float)0.0f);
            GLES20.glDrawArrays((int)5, (int)0, (int)4);
            GLES20.glViewport((int)0, (int)height, (int)uv_width, (int)uv_height);
            GLES20.glUniform2f((int)this.xUnitLoc, (float)(2.0f * transformMatrix[0] / (float)width), (float)(2.0f * transformMatrix[1] / (float)width));
            GLES20.glUniform4f((int)this.coeffsLoc, (float)-0.169f, (float)-0.331f, (float)0.499f, (float)0.5f);
            GLES20.glDrawArrays((int)5, (int)0, (int)4);
            GLES20.glViewport((int)(stride / 8), (int)height, (int)uv_width, (int)uv_height);
            GLES20.glUniform4f((int)this.coeffsLoc, (float)0.499f, (float)-0.418f, (float)-0.0813f, (float)0.5f);
            GLES20.glDrawArrays((int)5, (int)0, (int)4);
            GLES20.glReadPixels((int)0, (int)0, (int)(stride / 4), (int)total_height, (int)6408, (int)5121, (Buffer)buf);
            GlUtil.checkNoGLES2Error("YuvConverter.convert");
            GLES20.glBindTexture((int)36197, (int)0);
            this.eglBase.detachCurrent();
        }

        synchronized void release() {
            this.released = true;
            this.eglBase.makeCurrent();
            this.shader.release();
            this.eglBase.release();
        }
    }

    public static interface OnTextureFrameAvailableListener {
        public void onTextureFrameAvailable(int var1, float[] var2, long var3);
    }
}

