/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.android.media.peer;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public class SdpDescription {
    @JsonIgnore
    private final String SSRC_TAG_KEY = "a=ssrc:";
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="sdp")
    private String sdp;
    @JsonProperty(value="ssrc")
    private long ssrc;

    public SdpDescription(String type, String sdp) {
        this.type = type;
        this.sdp = sdp;
        this.ssrc = 0L;
        for (String line : sdp.split("\\r?\\n")) {
            if (!line.contains("a=ssrc:")) continue;
            this.ssrc = Long.parseLong(line.substring("a=ssrc:".length()).split("\\s")[0]);
            break;
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSdp() {
        return this.sdp;
    }

    public void setSdp(String sdp) {
        this.sdp = sdp;
    }

    public long getSsrc() {
        return this.ssrc;
    }

    public void setSsrc(long ssrc) {
        this.ssrc = ssrc;
    }
}

