/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.android.media;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.PowerManager;
import android.util.Log;
import com.voxeet.android.media.Media;

public class MediaPowerManager
implements SensorEventListener {
    private static final String TAG = MediaPowerManager.class.getSimpleName();
    private final int PROXIMITY_SCREEN_OFF_WAKE_LOCK = 32;
    private Context mContext;
    private PowerManager mPowerManager;
    private WifiManager mWifiManager;
    private SensorManager mSensorManager;
    private PowerManager.WakeLock mProximityWakeLock;
    private PowerManager.WakeLock mPartialWakeLock;
    private WifiManager.WifiLock mWifiLock;
    private Media mMedia;
    private Sensor mProximity;
    private boolean shouldRegisterForProximity = false;

    public MediaPowerManager(Context context, Media media) {
        this.mContext = context;
        this.mMedia = media;
        this.mPowerManager = (PowerManager)this.mContext.getSystemService("power");
        this.mWifiManager = (WifiManager)this.mContext.getSystemService("wifi");
        this.mSensorManager = (SensorManager)this.mContext.getSystemService("sensor");
        this.mProximity = this.mSensorManager.getDefaultSensor(8);
        if (Build.VERSION.SDK_INT >= 21 || Build.VERSION.SDK_INT < 21 && !Build.BRAND.contains("samsung")) {
            this.shouldRegisterForProximity = true;
        }
        try {
            this.mProximityWakeLock = Build.VERSION.SDK_INT >= 21 ? this.mPowerManager.newWakeLock(32, TAG) : this.mPowerManager.newWakeLock(32, TAG);
            this.mPartialWakeLock = this.mPowerManager.newWakeLock(1, TAG);
            this.mWifiLock = this.mWifiManager.createWifiLock(3, TAG);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Failed to create required WakeLock");
        }
    }

    public void acquire() {
        if (this.shouldRegisterForProximity) {
            this.mSensorManager.registerListener((SensorEventListener)this, this.mProximity, 3);
        }
        if (!this.mPartialWakeLock.isHeld()) {
            this.mPartialWakeLock.acquire();
        }
        if (!this.mWifiLock.isHeld()) {
            this.mWifiLock.acquire();
        }
    }

    public void release() {
        if (this.shouldRegisterForProximity) {
            this.mSensorManager.unregisterListener((SensorEventListener)this);
        }
        if (this.mPartialWakeLock.isHeld()) {
            this.mPartialWakeLock.release();
        }
        if (this.mWifiLock.isHeld()) {
            this.mWifiLock.release();
        }
        if (this.mProximityWakeLock.isHeld()) {
            this.mProximityWakeLock.release();
        }
    }

    public final void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    public final void onSensorChanged(SensorEvent event) {
        float distance = event.values[0];
        if (Build.VERSION.SDK_INT >= 21) {
            if (this.mMedia.outputRoute() == Media.AudioRoute.ROUTE_PHONE && this.mProximityWakeLock != null && !this.mProximityWakeLock.isHeld()) {
                if (distance <= 5.0f) {
                    this.mProximityWakeLock.acquire();
                }
            } else if (this.mProximityWakeLock != null && this.mProximityWakeLock.isHeld()) {
                this.mProximityWakeLock.release(0);
            }
        }
    }
}

