/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.android.media.video;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.Surface;
import com.voxeet.android.media.video.EglBase;
import com.voxeet.android.media.video.EglBase14;
import com.voxeet.android.media.video.GlRectDrawer;
import com.voxeet.android.media.video.ThreadUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

@TargetApi(value=19)
public class MediaCodecVideoEncoder {
    private static final String TAG = "MediaCodecVideoEncoder";
    private static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 5000;
    private static final int DEQUEUE_TIMEOUT = 0;
    private static MediaCodecVideoEncoder runningInstance = null;
    private static MediaCodecVideoEncoderErrorCallback errorCallback = null;
    private static int codecErrors = 0;
    private static Set<String> hwEncoderDisabledTypes = new HashSet<String>();
    private Thread mediaCodecThread;
    private MediaCodec mediaCodec;
    private ByteBuffer[] outputBuffers;
    private EglBase14 eglBase;
    private int width;
    private int height;
    private Surface inputSurface;
    private GlRectDrawer drawer;
    private static final String VP8_MIME_TYPE = "video/x-vnd.on2.vp8";
    private static final String VP9_MIME_TYPE = "video/x-vnd.on2.vp9";
    private static final String H264_MIME_TYPE = "video/avc";
    private static final String[] supportedVp8HwCodecPrefixes = new String[]{"OMX.qcom.", "OMX.Intel."};
    private static final String[] supportedVp9HwCodecPrefixes = new String[]{"OMX.qcom.", "OMX.Exynos."};
    private static final String[] supportedH264HwCodecPrefixes = new String[]{"OMX.qcom."};
    private static final String[] H264_HW_EXCEPTION_MODELS = new String[]{"SAMSUNG-SGH-I337", "Nexus 7", "Nexus 4"};
    private static final int VIDEO_ControlRateConstant = 2;
    private static final int COLOR_QCOM_FORMATYUV420PackedSemiPlanar32m = 2141391876;
    private static final int[] supportedColorList = new int[]{19, 21, 2141391872, 2141391876};
    private static final int[] supportedSurfaceColorList = new int[]{2130708361};
    private VideoCodecType type;
    private int colorFormat;
    private ByteBuffer configData = null;

    public static void setErrorCallback(MediaCodecVideoEncoderErrorCallback errorCallback) {
        Log.d((String)TAG, (String)"Set error callback");
        MediaCodecVideoEncoder.errorCallback = errorCallback;
    }

    public static void disableVp8HwCodec() {
        Log.w((String)TAG, (String)"VP8 encoding is disabled by application.");
        hwEncoderDisabledTypes.add(VP8_MIME_TYPE);
    }

    public static void disableVp9HwCodec() {
        Log.w((String)TAG, (String)"VP9 encoding is disabled by application.");
        hwEncoderDisabledTypes.add(VP9_MIME_TYPE);
    }

    public static void disableH264HwCodec() {
        Log.w((String)TAG, (String)"H.264 encoding is disabled by application.");
        hwEncoderDisabledTypes.add(H264_MIME_TYPE);
    }

    public static boolean isVp8HwSupported() {
        return !hwEncoderDisabledTypes.contains(VP8_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(VP8_MIME_TYPE, supportedVp8HwCodecPrefixes, supportedColorList) != null;
    }

    public static boolean isVp9HwSupported() {
        return !hwEncoderDisabledTypes.contains(VP9_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(VP9_MIME_TYPE, supportedVp9HwCodecPrefixes, supportedColorList) != null;
    }

    public static boolean isH264HwSupported() {
        return !hwEncoderDisabledTypes.contains(H264_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(H264_MIME_TYPE, supportedH264HwCodecPrefixes, supportedColorList) != null;
    }

    public static boolean isVp8HwSupportedUsingTextures() {
        return !hwEncoderDisabledTypes.contains(VP8_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(VP8_MIME_TYPE, supportedVp8HwCodecPrefixes, supportedSurfaceColorList) != null;
    }

    public static boolean isVp9HwSupportedUsingTextures() {
        return !hwEncoderDisabledTypes.contains(VP9_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(VP9_MIME_TYPE, supportedVp9HwCodecPrefixes, supportedSurfaceColorList) != null;
    }

    public static boolean isH264HwSupportedUsingTextures() {
        return !hwEncoderDisabledTypes.contains(H264_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(H264_MIME_TYPE, supportedH264HwCodecPrefixes, supportedSurfaceColorList) != null;
    }

    private static EncoderProperties findHwEncoder(String mime, String[] supportedHwCodecPrefixes, int[] colorList) {
        List<String> exceptionModels;
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        if (mime.equals(H264_MIME_TYPE) && (exceptionModels = Arrays.asList(H264_HW_EXCEPTION_MODELS)).contains(Build.MODEL)) {
            Log.w((String)TAG, (String)("Model: " + Build.MODEL + " has black listed H.264 encoder."));
            return null;
        }
        for (int i = 0; i < MediaCodecList.getCodecCount(); ++i) {
            MediaCodecInfo info = MediaCodecList.getCodecInfoAt((int)i);
            if (!info.isEncoder()) continue;
            String name = null;
            for (String mimeType : info.getSupportedTypes()) {
                if (!mimeType.equals(mime)) continue;
                name = info.getName();
                break;
            }
            if (name == null) continue;
            Log.v((String)TAG, (String)("Found candidate encoder " + name));
            boolean supportedCodec = false;
            for (String hwCodecPrefix : supportedHwCodecPrefixes) {
                if (!name.startsWith(hwCodecPrefix)) continue;
                supportedCodec = true;
                break;
            }
            if (!supportedCodec) continue;
            MediaCodecInfo.CodecCapabilities capabilities = info.getCapabilitiesForType(mime);
            for (int colorFormat : capabilities.colorFormats) {
                Log.v((String)TAG, (String)("   Color: 0x" + Integer.toHexString(colorFormat)));
            }
            for (int supportedColorFormat : colorList) {
                for (int codecColorFormat : capabilities.colorFormats) {
                    if (codecColorFormat != supportedColorFormat) continue;
                    Log.d((String)TAG, (String)("Found target encoder for mime " + mime + " : " + name + ". Color: 0x" + Integer.toHexString(codecColorFormat)));
                    return new EncoderProperties(name, codecColorFormat);
                }
            }
        }
        return null;
    }

    private void checkOnMediaCodecThread() {
        if (this.mediaCodecThread.getId() != Thread.currentThread().getId()) {
            throw new RuntimeException("MediaCodecVideoEncoder previously operated on " + this.mediaCodecThread + " but is now called on " + Thread.currentThread());
        }
    }

    public static void printStackTrace() {
        StackTraceElement[] mediaCodecStackTraces;
        if (runningInstance != null && MediaCodecVideoEncoder.runningInstance.mediaCodecThread != null && (mediaCodecStackTraces = MediaCodecVideoEncoder.runningInstance.mediaCodecThread.getStackTrace()).length > 0) {
            Log.d((String)TAG, (String)"MediaCodecVideoEncoder stacks trace:");
            for (StackTraceElement stackTrace : mediaCodecStackTraces) {
                Log.d((String)TAG, (String)stackTrace.toString());
            }
        }
    }

    static MediaCodec createByCodecName(String codecName) {
        try {
            return MediaCodec.createByCodecName((String)codecName);
        }
        catch (Exception e) {
            return null;
        }
    }

    boolean initEncode(VideoCodecType type, int width, int height, int kbps, int fps, EglBase14.Context sharedContext) {
        boolean useSurface = sharedContext != null;
        Log.d((String)TAG, (String)("Java initEncode: " + (Object)((Object)type) + " : " + width + " x " + height + ". @ " + kbps + " kbps. Fps: " + fps + ". Encode from texture : " + useSurface));
        this.width = width;
        this.height = height;
        if (this.mediaCodecThread != null) {
            throw new RuntimeException("Forgot to release()?");
        }
        EncoderProperties properties = null;
        String mime = null;
        int keyFrameIntervalSec = 0;
        if (type == VideoCodecType.VIDEO_CODEC_VP8) {
            mime = VP8_MIME_TYPE;
            properties = MediaCodecVideoEncoder.findHwEncoder(VP8_MIME_TYPE, supportedVp8HwCodecPrefixes, useSurface ? supportedSurfaceColorList : supportedColorList);
            keyFrameIntervalSec = 100;
        } else if (type == VideoCodecType.VIDEO_CODEC_VP9) {
            mime = VP9_MIME_TYPE;
            properties = MediaCodecVideoEncoder.findHwEncoder(VP9_MIME_TYPE, supportedVp9HwCodecPrefixes, useSurface ? supportedSurfaceColorList : supportedColorList);
            keyFrameIntervalSec = 100;
        } else if (type == VideoCodecType.VIDEO_CODEC_H264) {
            mime = H264_MIME_TYPE;
            properties = MediaCodecVideoEncoder.findHwEncoder(H264_MIME_TYPE, supportedH264HwCodecPrefixes, useSurface ? supportedSurfaceColorList : supportedColorList);
            keyFrameIntervalSec = 20;
        }
        if (properties == null) {
            throw new RuntimeException("Can not find HW encoder for " + (Object)((Object)type));
        }
        runningInstance = this;
        this.colorFormat = properties.colorFormat;
        Log.d((String)TAG, (String)("Color format: " + this.colorFormat));
        this.mediaCodecThread = Thread.currentThread();
        try {
            MediaFormat format = MediaFormat.createVideoFormat((String)mime, (int)width, (int)height);
            format.setInteger("bitrate", 1000 * kbps);
            format.setInteger("bitrate-mode", 2);
            format.setInteger("color-format", properties.colorFormat);
            format.setInteger("frame-rate", fps);
            format.setInteger("i-frame-interval", keyFrameIntervalSec);
            Log.d((String)TAG, (String)("  Format: " + format));
            this.mediaCodec = MediaCodecVideoEncoder.createByCodecName(properties.codecName);
            this.type = type;
            if (this.mediaCodec == null) {
                Log.e((String)TAG, (String)"Can not create media encoder");
                return false;
            }
            this.mediaCodec.configure(format, null, null, 1);
            if (useSurface) {
                this.eglBase = new EglBase14(sharedContext, EglBase.CONFIG_RECORDABLE);
                this.inputSurface = this.mediaCodec.createInputSurface();
                this.eglBase.createSurface(this.inputSurface);
                this.drawer = new GlRectDrawer();
            }
            this.mediaCodec.start();
            this.outputBuffers = this.mediaCodec.getOutputBuffers();
            Log.d((String)TAG, (String)("Output buffers: " + this.outputBuffers.length));
        }
        catch (IllegalStateException e) {
            Log.e((String)TAG, (String)"initEncode failed", (Throwable)e);
            return false;
        }
        return true;
    }

    ByteBuffer[] getInputBuffers() {
        ByteBuffer[] inputBuffers = this.mediaCodec.getInputBuffers();
        Log.d((String)TAG, (String)("Input buffers: " + inputBuffers.length));
        return inputBuffers;
    }

    boolean encodeBuffer(boolean isKeyframe, int inputBuffer, int size, long presentationTimestampUs) {
        this.checkOnMediaCodecThread();
        try {
            if (isKeyframe) {
                Log.d((String)TAG, (String)"Sync frame request");
                Bundle b = new Bundle();
                b.putInt("request-sync", 0);
                this.mediaCodec.setParameters(b);
            }
            this.mediaCodec.queueInputBuffer(inputBuffer, 0, size, presentationTimestampUs, 0);
            return true;
        }
        catch (IllegalStateException e) {
            Log.e((String)TAG, (String)"encodeBuffer failed", (Throwable)e);
            return false;
        }
    }

    boolean encodeTexture(boolean isKeyframe, int oesTextureId, float[] transformationMatrix, long presentationTimestampUs) {
        this.checkOnMediaCodecThread();
        try {
            if (isKeyframe) {
                Log.d((String)TAG, (String)"Sync frame request");
                Bundle b = new Bundle();
                b.putInt("request-sync", 0);
                this.mediaCodec.setParameters(b);
            }
            this.eglBase.makeCurrent();
            GLES20.glClear((int)16384);
            this.drawer.drawOes(oesTextureId, transformationMatrix, this.width, this.height, 0, 0, this.width, this.height);
            this.eglBase.swapBuffers(TimeUnit.MICROSECONDS.toNanos(presentationTimestampUs));
            return true;
        }
        catch (RuntimeException e) {
            Log.e((String)TAG, (String)"encodeTexture failed", (Throwable)e);
            return false;
        }
    }

    void release() {
        Log.d((String)TAG, (String)"Java releaseEncoder");
        this.checkOnMediaCodecThread();
        final CountDownLatch releaseDone = new CountDownLatch(1);
        Runnable runMediaCodecRelease = new Runnable(){

            @Override
            public void run() {
                try {
                    Log.d((String)MediaCodecVideoEncoder.TAG, (String)"Java releaseEncoder on release thread");
                    MediaCodecVideoEncoder.this.mediaCodec.stop();
                    MediaCodecVideoEncoder.this.mediaCodec.release();
                    Log.d((String)MediaCodecVideoEncoder.TAG, (String)"Java releaseEncoder on release thread done");
                }
                catch (Exception e) {
                    Log.e((String)MediaCodecVideoEncoder.TAG, (String)"Media encoder release failed", (Throwable)e);
                }
                releaseDone.countDown();
            }
        };
        new Thread(runMediaCodecRelease).start();
        if (!ThreadUtils.awaitUninterruptibly(releaseDone, 5000L)) {
            Log.e((String)TAG, (String)"Media encoder release timeout");
            ++codecErrors;
            if (errorCallback != null) {
                Log.e((String)TAG, (String)("Invoke codec error callback. Errors: " + codecErrors));
                errorCallback.onMediaCodecVideoEncoderCriticalError(codecErrors);
            }
        }
        this.mediaCodec = null;
        this.mediaCodecThread = null;
        if (this.drawer != null) {
            this.drawer.release();
            this.drawer = null;
        }
        if (this.eglBase != null) {
            this.eglBase.release();
            this.eglBase = null;
        }
        if (this.inputSurface != null) {
            this.inputSurface.release();
            this.inputSurface = null;
        }
        runningInstance = null;
        Log.d((String)TAG, (String)"Java releaseEncoder done");
    }

    private boolean setRates(int kbps, int frameRateIgnored) {
        this.checkOnMediaCodecThread();
        Log.v((String)TAG, (String)("setRates: " + kbps + " kbps. Fps: " + frameRateIgnored));
        try {
            Bundle params = new Bundle();
            params.putInt("video-bitrate", 1000 * kbps);
            this.mediaCodec.setParameters(params);
            return true;
        }
        catch (IllegalStateException e) {
            Log.e((String)TAG, (String)"setRates failed", (Throwable)e);
            return false;
        }
    }

    int dequeueInputBuffer() {
        this.checkOnMediaCodecThread();
        try {
            return this.mediaCodec.dequeueInputBuffer(0L);
        }
        catch (IllegalStateException e) {
            Log.e((String)TAG, (String)"dequeueIntputBuffer failed", (Throwable)e);
            return -2;
        }
    }

    OutputBufferInfo dequeueOutputBuffer() {
        this.checkOnMediaCodecThread();
        try {
            MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
            int result = this.mediaCodec.dequeueOutputBuffer(info, 0L);
            if (result >= 0) {
                boolean isConfigFrame;
                boolean bl = isConfigFrame = (info.flags & 2) != 0;
                if (isConfigFrame) {
                    Log.d((String)TAG, (String)("Config frame generated. Offset: " + info.offset + ". Size: " + info.size));
                    this.configData = ByteBuffer.allocateDirect(info.size);
                    this.outputBuffers[result].position(info.offset);
                    this.outputBuffers[result].limit(info.offset + info.size);
                    this.configData.put(this.outputBuffers[result]);
                    this.mediaCodec.releaseOutputBuffer(result, false);
                    result = this.mediaCodec.dequeueOutputBuffer(info, 0L);
                }
            }
            if (result >= 0) {
                boolean isKeyFrame;
                ByteBuffer outputBuffer = this.outputBuffers[result].duplicate();
                outputBuffer.position(info.offset);
                outputBuffer.limit(info.offset + info.size);
                boolean bl = isKeyFrame = (info.flags & 1) != 0;
                if (isKeyFrame) {
                    Log.d((String)TAG, (String)"Sync frame generated");
                }
                if (isKeyFrame && this.type == VideoCodecType.VIDEO_CODEC_H264) {
                    Log.d((String)TAG, (String)("Appending config frame of size " + this.configData.capacity() + " to output buffer with offset " + info.offset + ", size " + info.size));
                    ByteBuffer keyFrameBuffer = ByteBuffer.allocateDirect(this.configData.capacity() + info.size);
                    this.configData.rewind();
                    keyFrameBuffer.put(this.configData);
                    keyFrameBuffer.put(outputBuffer);
                    keyFrameBuffer.position(0);
                    return new OutputBufferInfo(result, keyFrameBuffer, isKeyFrame, info.presentationTimeUs);
                }
                return new OutputBufferInfo(result, outputBuffer.slice(), isKeyFrame, info.presentationTimeUs);
            }
            if (result == -3) {
                this.outputBuffers = this.mediaCodec.getOutputBuffers();
                return this.dequeueOutputBuffer();
            }
            if (result == -2) {
                return this.dequeueOutputBuffer();
            }
            if (result == -1) {
                return null;
            }
            throw new RuntimeException("dequeueOutputBuffer: " + result);
        }
        catch (IllegalStateException e) {
            Log.e((String)TAG, (String)"dequeueOutputBuffer failed", (Throwable)e);
            return new OutputBufferInfo(-1, null, false, -1L);
        }
    }

    boolean releaseOutputBuffer(int index) {
        this.checkOnMediaCodecThread();
        try {
            this.mediaCodec.releaseOutputBuffer(index, false);
            return true;
        }
        catch (IllegalStateException e) {
            Log.e((String)TAG, (String)"releaseOutputBuffer failed", (Throwable)e);
            return false;
        }
    }

    static class OutputBufferInfo {
        public final int index;
        public final ByteBuffer buffer;
        public final boolean isKeyFrame;
        public final long presentationTimestampUs;

        public OutputBufferInfo(int index, ByteBuffer buffer, boolean isKeyFrame, long presentationTimestampUs) {
            this.index = index;
            this.buffer = buffer;
            this.isKeyFrame = isKeyFrame;
            this.presentationTimestampUs = presentationTimestampUs;
        }
    }

    private static class EncoderProperties {
        public final String codecName;
        public final int colorFormat;

        public EncoderProperties(String codecName, int colorFormat) {
            this.codecName = codecName;
            this.colorFormat = colorFormat;
        }
    }

    public static interface MediaCodecVideoEncoderErrorCallback {
        public void onMediaCodecVideoEncoderCriticalError(int var1);
    }

    public static enum VideoCodecType {
        VIDEO_CODEC_VP8,
        VIDEO_CODEC_VP9,
        VIDEO_CODEC_H264;

    }
}

