/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.android.media;

import android.content.Context;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.PowerManager;
import android.util.Log;

public class MediaPowerManager {
    private static final String TAG = MediaPowerManager.class.getSimpleName();
    private static final int PROXIMITY_SCREEN_OFF_WAKE_LOCK = 32;
    private Context mContext;
    private PowerManager mPowerManager;
    private WifiManager mWifiManager;
    private PowerManager.WakeLock mProximityWakeLock;
    private PowerManager.WakeLock mPartialWakeLock;
    private WifiManager.WifiLock mWifiLock;

    public MediaPowerManager(Context context) {
        this.mContext = context;
        this.mPowerManager = (PowerManager)this.mContext.getSystemService("power");
        this.mWifiManager = (WifiManager)this.mContext.getSystemService("wifi");
        try {
            this.mProximityWakeLock = this.mPowerManager.newWakeLock(32, TAG);
            this.mPartialWakeLock = this.mPowerManager.newWakeLock(1, TAG);
            this.mWifiLock = this.mWifiManager.createWifiLock(3, TAG);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Failed to create required WakeLock");
        }
    }

    public void aquire() {
        if (!this.mPartialWakeLock.isHeld()) {
            this.mPartialWakeLock.acquire();
        }
        if (!this.mWifiLock.isHeld()) {
            this.mWifiLock.acquire();
        }
    }

    public void release() {
        if (this.mPartialWakeLock.isHeld()) {
            this.mPartialWakeLock.release();
        }
        if (this.mWifiLock.isHeld()) {
            this.mWifiLock.release();
        }
    }

    public void aquireProximity() {
        String model = Build.BRAND;
        if (!model.toLowerCase().contains("samsung") && !this.mProximityWakeLock.isHeld()) {
            this.mProximityWakeLock.acquire();
        }
    }

    public void releaseProximity() {
        if (this.mProximityWakeLock.isHeld()) {
            this.mProximityWakeLock.release();
        }
    }
}

