/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.android.media.video;

import android.content.Context;
import android.hardware.Camera;
import android.os.Handler;
import android.os.SystemClock;
import android.util.Log;
import android.view.WindowManager;
import com.voxeet.android.media.VideoCapturer;
import com.voxeet.android.media.video.CameraEnumerationAndroid;
import com.voxeet.android.media.video.RendererCommon;
import com.voxeet.android.media.video.SurfaceTextureHelper;
import com.voxeet.android.media.video.ThreadUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class VideoCapturerAndroid
implements VideoCapturer,
Camera.PreviewCallback,
SurfaceTextureHelper.OnTextureFrameAvailableListener {
    private static final String TAG = "VideoCapturerAndroid";
    private static final int CAMERA_OBSERVER_PERIOD_MS = 2000;
    private static final int CAMERA_FREEZE_REPORT_TIMOUT_MS = 4000;
    private static final int CAMERA_STOP_TIMEOUT_MS = 7000;
    private boolean isDisposed = false;
    private Camera camera;
    private final Object handlerLock = new Object();
    private Handler cameraThreadHandler;
    private Context applicationContext;
    private final Object cameraIdLock = new Object();
    private int id;
    private Camera.CameraInfo info;
    private final CameraStatistics cameraStatistics;
    private int requestedWidth;
    private int requestedHeight;
    private int requestedFramerate;
    private CameraEnumerationAndroid.CaptureFormat captureFormat;
    private final Object pendingCameraSwitchLock = new Object();
    private volatile boolean pendingCameraSwitch;
    private VideoCapturer.CapturerObserver frameObserver = null;
    private final CameraEventsHandler eventsHandler;
    private boolean firstFrameReported;
    private static final int NUMBER_OF_CAPTURE_BUFFERS = 3;
    private final Set<byte[]> queuedBuffers = new HashSet<byte[]>();
    private final boolean isCapturingToTexture;
    private SurfaceTextureHelper surfaceHelper;
    private boolean dropNextFrame = false;
    private static final int MAX_OPEN_CAMERA_ATTEMPTS = 3;
    private static final int OPEN_CAMERA_DELAY_MS = 500;
    private int openCameraAttempts;
    private final Camera.ErrorCallback cameraErrorCallback = new Camera.ErrorCallback(){

        public void onError(int error, Camera camera) {
            String errorMessage = error == 100 ? "Camera server died!" : "Camera error: " + error;
            Log.e((String)VideoCapturerAndroid.TAG, (String)errorMessage);
            if (VideoCapturerAndroid.this.eventsHandler != null) {
                VideoCapturerAndroid.this.eventsHandler.onCameraError(errorMessage);
            }
        }
    };
    private final Runnable cameraObserver = new Runnable(){
        private int freezePeriodCount;

        @Override
        public void run() {
            int cameraFramesCount = VideoCapturerAndroid.this.cameraStatistics.getAndResetFrameCount();
            int cameraFps = (cameraFramesCount * 1000 + 1000) / 2000;
            Log.d((String)VideoCapturerAndroid.TAG, (String)("Camera fps: " + cameraFps + "."));
            if (cameraFramesCount == 0) {
                ++this.freezePeriodCount;
                if (2000 * this.freezePeriodCount >= 4000 && VideoCapturerAndroid.this.eventsHandler != null) {
                    Log.e((String)VideoCapturerAndroid.TAG, (String)"Camera freezed.");
                    if (VideoCapturerAndroid.this.surfaceHelper.isTextureInUse()) {
                        VideoCapturerAndroid.this.eventsHandler.onCameraFreezed("Camera failure. Client must return video buffers.");
                    } else {
                        VideoCapturerAndroid.this.eventsHandler.onCameraFreezed("Camera failure.");
                    }
                    return;
                }
            } else {
                this.freezePeriodCount = 0;
            }
            VideoCapturerAndroid.this.maybePostDelayedOnCameraThread(2000, this);
        }
    };

    public static VideoCapturerAndroid create(String name, CameraEventsHandler eventsHandler) {
        return VideoCapturerAndroid.create(name, eventsHandler, false);
    }

    public static VideoCapturerAndroid create(String name, CameraEventsHandler eventsHandler, boolean captureToTexture) {
        int cameraId = VideoCapturerAndroid.lookupDeviceName(name);
        if (cameraId == -1) {
            return null;
        }
        return new VideoCapturerAndroid(cameraId, eventsHandler, captureToTexture);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace() {
        StackTraceElement[] cameraStackTraces;
        Thread cameraThread = null;
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.cameraThreadHandler != null) {
                cameraThread = this.cameraThreadHandler.getLooper().getThread();
            }
        }
        if (cameraThread != null && (cameraStackTraces = cameraThread.getStackTrace()).length > 0) {
            Log.d((String)TAG, (String)"VideoCapturerAndroid stacks trace:");
            for (StackTraceElement stackTrace : cameraStackTraces) {
                Log.d((String)TAG, (String)stackTrace.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchCamera(final CameraSwitchHandler switchEventsHandler) {
        if (Camera.getNumberOfCameras() < 2) {
            if (switchEventsHandler != null) {
                switchEventsHandler.onCameraSwitchError("No camera to switch to.");
            }
            return;
        }
        Object object = this.pendingCameraSwitchLock;
        synchronized (object) {
            if (this.pendingCameraSwitch) {
                Log.w((String)TAG, (String)"Ignoring camera switch request.");
                if (switchEventsHandler != null) {
                    switchEventsHandler.onCameraSwitchError("Pending camera switch already in progress.");
                }
                return;
            }
            this.pendingCameraSwitch = true;
        }
        boolean didPost = this.maybePostOnCameraThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                VideoCapturerAndroid.this.switchCameraOnCameraThread();
                Object object = VideoCapturerAndroid.this.pendingCameraSwitchLock;
                synchronized (object) {
                    VideoCapturerAndroid.this.pendingCameraSwitch = false;
                }
                if (switchEventsHandler != null) {
                    switchEventsHandler.onCameraSwitchDone(((VideoCapturerAndroid)VideoCapturerAndroid.this).info.facing == 1);
                }
            }
        });
        if (!didPost && switchEventsHandler != null) {
            switchEventsHandler.onCameraSwitchError("Camera is stopped.");
        }
    }

    public void onOutputFormatRequest(final int width, final int height, final int framerate) {
        this.maybePostOnCameraThread(new Runnable(){

            @Override
            public void run() {
                VideoCapturerAndroid.this.onOutputFormatRequestOnCameraThread(width, height, framerate);
            }
        });
    }

    public void changeCaptureFormat(final int width, final int height, final int framerate) {
        this.maybePostOnCameraThread(new Runnable(){

            @Override
            public void run() {
                VideoCapturerAndroid.this.startPreviewOnCameraThread(width, height, framerate);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getCurrentCameraId() {
        Object object = this.cameraIdLock;
        synchronized (object) {
            return this.id;
        }
    }

    @Override
    public List<CameraEnumerationAndroid.CaptureFormat> getSupportedFormats() {
        return CameraEnumerationAndroid.getSupportedFormats(this.getCurrentCameraId());
    }

    public boolean isCapturingToTexture() {
        return this.isCapturingToTexture;
    }

    private VideoCapturerAndroid(int cameraId, CameraEventsHandler eventsHandler, boolean captureToTexture) {
        this.id = cameraId;
        this.eventsHandler = eventsHandler;
        this.isCapturingToTexture = captureToTexture;
        this.cameraStatistics = new CameraStatistics();
        Log.d((String)TAG, (String)("VideoCapturerAndroid isCapturingToTexture : " + this.isCapturingToTexture));
    }

    private void checkIsOnCameraThread() {
        if (Thread.currentThread() != this.cameraThreadHandler.getLooper().getThread()) {
            throw new IllegalStateException("Wrong thread");
        }
    }

    private static int lookupDeviceName(String deviceName) {
        Log.d((String)TAG, (String)("lookupDeviceName: " + deviceName));
        if (deviceName == null || Camera.getNumberOfCameras() == 0) {
            return -1;
        }
        if (deviceName.isEmpty()) {
            return 0;
        }
        for (int i = 0; i < Camera.getNumberOfCameras(); ++i) {
            if (!deviceName.equals(CameraEnumerationAndroid.getDeviceName(i))) continue;
            return i;
        }
        return -1;
    }

    private boolean maybePostOnCameraThread(Runnable runnable) {
        return this.maybePostDelayedOnCameraThread(0, runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean maybePostDelayedOnCameraThread(int delayMs, Runnable runnable) {
        Object object = this.handlerLock;
        synchronized (object) {
            return this.cameraThreadHandler != null && this.cameraThreadHandler.postAtTime(runnable, (Object)this, SystemClock.uptimeMillis() + (long)delayMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Log.d((String)TAG, (String)"release");
        if (this.isDisposed()) {
            throw new IllegalStateException("Already released");
        }
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.cameraThreadHandler != null) {
                throw new IllegalStateException("dispose() called while camera is running");
            }
        }
        this.isDisposed = true;
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startCapture(final int width, final int height, final int framerate, SurfaceTextureHelper surfaceTextureHelper, final Context applicationContext, final VideoCapturer.CapturerObserver frameObserver) {
        Log.d((String)TAG, (String)("startCapture requested: " + width + "x" + height + "@" + framerate));
        if (surfaceTextureHelper == null) {
            frameObserver.onCapturerStarted(false);
            if (this.eventsHandler != null) {
                this.eventsHandler.onCameraError("No SurfaceTexture created.");
            }
            return;
        }
        if (applicationContext == null) {
            throw new IllegalArgumentException("applicationContext not set.");
        }
        if (frameObserver == null) {
            throw new IllegalArgumentException("frameObserver not set.");
        }
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.cameraThreadHandler != null) {
                throw new RuntimeException("Camera has already been started.");
            }
            this.cameraThreadHandler = surfaceTextureHelper.getHandler();
            this.surfaceHelper = surfaceTextureHelper;
            boolean didPost = this.maybePostOnCameraThread(new Runnable(){

                @Override
                public void run() {
                    VideoCapturerAndroid.this.openCameraAttempts = 0;
                    VideoCapturerAndroid.this.startCaptureOnCameraThread(width, height, framerate, frameObserver, applicationContext);
                }
            });
            if (!didPost) {
                frameObserver.onCapturerStarted(false);
                if (this.eventsHandler != null) {
                    this.eventsHandler.onCameraError("Could not post task to camera thread.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startCaptureOnCameraThread(final int width, final int height, final int framerate, final VideoCapturer.CapturerObserver frameObserver, final Context applicationContext) {
        RuntimeException error = null;
        this.checkIsOnCameraThread();
        if (this.camera != null) {
            Log.e((String)TAG, (String)"startCaptureOnCameraThread: Camera has already been started.");
            return;
        }
        this.applicationContext = applicationContext;
        this.frameObserver = frameObserver;
        this.firstFrameReported = false;
        try {
            try {
                Object object = this.cameraIdLock;
                synchronized (object) {
                    Log.d((String)TAG, (String)("Opening camera " + this.id));
                    if (this.eventsHandler != null) {
                        this.eventsHandler.onCameraOpening(this.id);
                    }
                    this.camera = Camera.open((int)this.id);
                    this.info = new Camera.CameraInfo();
                    Camera.getCameraInfo((int)this.id, (Camera.CameraInfo)this.info);
                }
            }
            catch (RuntimeException e) {
                ++this.openCameraAttempts;
                if (this.openCameraAttempts < 3) {
                    Log.e((String)TAG, (String)"Camera.open failed, retrying", (Throwable)e);
                    this.maybePostDelayedOnCameraThread(500, new Runnable(){

                        @Override
                        public void run() {
                            VideoCapturerAndroid.this.startCaptureOnCameraThread(width, height, framerate, frameObserver, applicationContext);
                        }
                    });
                    return;
                }
                throw e;
            }
            try {
                this.camera.setPreviewTexture(this.surfaceHelper.getSurfaceTexture());
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"setPreviewTexture failed", (Throwable)error);
                throw new RuntimeException(e);
            }
            Log.d((String)TAG, (String)("Camera orientation: " + this.info.orientation + " .Device orientation: " + this.getDeviceOrientation()));
            this.camera.setErrorCallback(this.cameraErrorCallback);
            this.startPreviewOnCameraThread(width, height, framerate);
            frameObserver.onCapturerStarted(true);
            if (this.isCapturingToTexture) {
                this.surfaceHelper.startListening(this);
            }
            this.maybePostDelayedOnCameraThread(2000, this.cameraObserver);
            return;
        }
        catch (RuntimeException e) {
            error = e;
            Log.e((String)TAG, (String)"startCapture failed", (Throwable)error);
            this.stopCaptureOnCameraThread();
            Object object = this.handlerLock;
            synchronized (object) {
                this.cameraThreadHandler.removeCallbacksAndMessages((Object)this);
                this.cameraThreadHandler = null;
            }
            frameObserver.onCapturerStarted(false);
            if (this.eventsHandler != null) {
                this.eventsHandler.onCameraError("Camera can not be started.");
            }
            return;
        }
    }

    private void startPreviewOnCameraThread(int width, int height, int framerate) {
        this.checkIsOnCameraThread();
        Log.d((String)TAG, (String)("startPreviewOnCameraThread requested: " + width + "x" + height + "@" + framerate));
        if (this.camera == null) {
            Log.e((String)TAG, (String)"Calling startPreviewOnCameraThread on stopped camera.");
            return;
        }
        this.requestedWidth = width;
        this.requestedHeight = height;
        this.requestedFramerate = framerate;
        Camera.Parameters parameters = this.camera.getParameters();
        for (int[] fpsRange : parameters.getSupportedPreviewFpsRange()) {
            Log.d((String)TAG, (String)("Available fps range: " + fpsRange[0] + ":" + fpsRange[1]));
        }
        int[] range = CameraEnumerationAndroid.getFramerateRange(parameters, framerate * 1000);
        Camera.Size previewSize = CameraEnumerationAndroid.getClosestSupportedSize(parameters.getSupportedPreviewSizes(), width, height);
        CameraEnumerationAndroid.CaptureFormat captureFormat = new CameraEnumerationAndroid.CaptureFormat(previewSize.width, previewSize.height, range[0], range[1]);
        if (captureFormat.isSameFormat(this.captureFormat)) {
            return;
        }
        Log.d((String)TAG, (String)("isVideoStabilizationSupported: " + parameters.isVideoStabilizationSupported()));
        if (parameters.isVideoStabilizationSupported()) {
            parameters.setVideoStabilization(true);
        }
        if (captureFormat.maxFramerate > 0) {
            parameters.setPreviewFpsRange(captureFormat.minFramerate, captureFormat.maxFramerate);
        }
        parameters.setPreviewSize(captureFormat.width, captureFormat.height);
        if (!this.isCapturingToTexture) {
            parameters.setPreviewFormat(captureFormat.imageFormat);
        }
        Camera.Size pictureSize = CameraEnumerationAndroid.getClosestSupportedSize(parameters.getSupportedPictureSizes(), width, height);
        parameters.setPictureSize(pictureSize.width, pictureSize.height);
        if (this.captureFormat != null) {
            this.camera.stopPreview();
            this.dropNextFrame = true;
            this.camera.setPreviewCallbackWithBuffer(null);
        }
        Log.d((String)TAG, (String)("Start capturing: " + captureFormat));
        this.captureFormat = captureFormat;
        List focusModes = parameters.getSupportedFocusModes();
        if (focusModes.contains("continuous-video")) {
            parameters.setFocusMode("continuous-video");
        }
        this.camera.setParameters(parameters);
        this.camera.setDisplayOrientation(0);
        if (!this.isCapturingToTexture) {
            this.queuedBuffers.clear();
            int frameSize = captureFormat.frameSize();
            for (int i = 0; i < 3; ++i) {
                ByteBuffer buffer = ByteBuffer.allocateDirect(frameSize);
                this.queuedBuffers.add(buffer.array());
                this.camera.addCallbackBuffer(buffer.array());
            }
            this.camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
        }
        this.camera.startPreview();
    }

    @Override
    public void stopCapture() throws InterruptedException {
        Log.d((String)TAG, (String)"stopCapture");
        final CountDownLatch barrier = new CountDownLatch(1);
        boolean didPost = this.maybePostOnCameraThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                VideoCapturerAndroid.this.stopCaptureOnCameraThread();
                Object object = VideoCapturerAndroid.this.handlerLock;
                synchronized (object) {
                    VideoCapturerAndroid.this.cameraThreadHandler.removeCallbacksAndMessages((Object)this);
                    VideoCapturerAndroid.this.cameraThreadHandler = null;
                    VideoCapturerAndroid.this.surfaceHelper = null;
                }
                barrier.countDown();
            }
        });
        if (!didPost) {
            Log.e((String)TAG, (String)"Calling stopCapture() for already stopped camera.");
            return;
        }
        if (!barrier.await(7000L, TimeUnit.MILLISECONDS)) {
            Log.e((String)TAG, (String)"Camera stop timeout");
            this.printStackTrace();
            if (this.eventsHandler != null) {
                this.eventsHandler.onCameraError("Camera stop timeout");
            }
        }
        Log.d((String)TAG, (String)"stopCapture done");
    }

    private void stopCaptureOnCameraThread() {
        this.checkIsOnCameraThread();
        Log.d((String)TAG, (String)"stopCaptureOnCameraThread");
        if (this.surfaceHelper != null) {
            this.surfaceHelper.stopListening();
        }
        this.cameraThreadHandler.removeCallbacks(this.cameraObserver);
        this.cameraStatistics.getAndResetFrameCount();
        Log.d((String)TAG, (String)"Stop preview.");
        if (this.camera != null) {
            this.camera.stopPreview();
            this.camera.setPreviewCallbackWithBuffer(null);
        }
        this.queuedBuffers.clear();
        this.captureFormat = null;
        Log.d((String)TAG, (String)"Release camera.");
        if (this.camera != null) {
            this.camera.release();
            this.camera = null;
        }
        if (this.eventsHandler != null) {
            this.eventsHandler.onCameraClosed();
        }
        Log.d((String)TAG, (String)"stopCaptureOnCameraThread done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchCameraOnCameraThread() {
        this.checkIsOnCameraThread();
        Log.d((String)TAG, (String)"switchCameraOnCameraThread");
        this.stopCaptureOnCameraThread();
        Object object = this.cameraIdLock;
        synchronized (object) {
            this.id = (this.id + 1) % Camera.getNumberOfCameras();
        }
        this.dropNextFrame = true;
        this.startCaptureOnCameraThread(this.requestedWidth, this.requestedHeight, this.requestedFramerate, this.frameObserver, this.applicationContext);
        Log.d((String)TAG, (String)"switchCameraOnCameraThread done");
    }

    private void onOutputFormatRequestOnCameraThread(int width, int height, int framerate) {
        this.checkIsOnCameraThread();
        if (this.camera == null) {
            Log.e((String)TAG, (String)"Calling onOutputFormatRequest() on stopped camera.");
            return;
        }
        Log.d((String)TAG, (String)("onOutputFormatRequestOnCameraThread: " + width + "x" + height + "@" + framerate));
        this.frameObserver.onOutputFormatRequest(width, height, framerate);
    }

    Handler getCameraThreadHandler() {
        return this.cameraThreadHandler;
    }

    private int getDeviceOrientation() {
        int orientation = 0;
        WindowManager wm = (WindowManager)this.applicationContext.getSystemService("window");
        switch (wm.getDefaultDisplay().getRotation()) {
            case 1: {
                orientation = 90;
                break;
            }
            case 2: {
                orientation = 180;
                break;
            }
            case 3: {
                orientation = 270;
                break;
            }
            default: {
                orientation = 0;
            }
        }
        return orientation;
    }

    private int getFrameOrientation() {
        int rotation = this.getDeviceOrientation();
        if (this.info.facing == 0) {
            rotation = 360 - rotation;
        }
        return (this.info.orientation + rotation) % 360;
    }

    public void onPreviewFrame(byte[] data, Camera callbackCamera) {
        if (this.cameraThreadHandler == null) {
            return;
        }
        this.checkIsOnCameraThread();
        if (!this.queuedBuffers.contains(data)) {
            return;
        }
        if (this.camera != callbackCamera) {
            throw new RuntimeException("Unexpected camera in callback!");
        }
        long captureTimeNs = TimeUnit.MILLISECONDS.toNanos(SystemClock.elapsedRealtime());
        if (this.eventsHandler != null && !this.firstFrameReported) {
            this.eventsHandler.onFirstFrameAvailable();
            this.firstFrameReported = true;
        }
        this.cameraStatistics.addFrame();
        this.frameObserver.onByteBufferFrameCaptured(data, this.captureFormat.width, this.captureFormat.height, this.getFrameOrientation(), captureTimeNs);
        this.camera.addCallbackBuffer(data);
    }

    @Override
    public void onTextureFrameAvailable(int oesTextureId, float[] transformMatrix, long timestampNs) {
        if (this.cameraThreadHandler == null) {
            throw new RuntimeException("onTextureFrameAvailable() called after stopCapture().");
        }
        this.checkIsOnCameraThread();
        if (this.dropNextFrame) {
            this.surfaceHelper.returnTextureFrame();
            this.dropNextFrame = false;
            return;
        }
        if (this.eventsHandler != null && !this.firstFrameReported) {
            this.eventsHandler.onFirstFrameAvailable();
            this.firstFrameReported = true;
        }
        int rotation = this.getFrameOrientation();
        if (this.info.facing == 1) {
            transformMatrix = RendererCommon.multiplyMatrices(transformMatrix, RendererCommon.horizontalFlipMatrix());
        }
        this.cameraStatistics.addFrame();
        this.frameObserver.onTextureFrameCaptured(this.captureFormat.width, this.captureFormat.height, oesTextureId, transformMatrix, rotation, timestampNs);
    }

    public static interface CameraSwitchHandler {
        public void onCameraSwitchDone(boolean var1);

        public void onCameraSwitchError(String var1);
    }

    public static interface CameraEventsHandler {
        public void onCameraError(String var1);

        public void onCameraFreezed(String var1);

        public void onCameraOpening(int var1);

        public void onFirstFrameAvailable();

        public void onCameraClosed();
    }

    private static class CameraStatistics {
        private int frameCount = 0;
        private final ThreadUtils.ThreadChecker threadChecker = new ThreadUtils.ThreadChecker();

        CameraStatistics() {
            this.threadChecker.detachThread();
        }

        public void addFrame() {
            this.threadChecker.checkIsOnValidThread();
            ++this.frameCount;
        }

        public int getAndResetFrameCount() {
            this.threadChecker.checkIsOnValidThread();
            int count = this.frameCount;
            this.frameCount = 0;
            return count;
        }
    }
}

