package com.voxeet.android.media;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class PendingPeerOperation {
	public enum Type{
		OFFER(0),
		ANSWER(1),
		CANDIDATES(2);
		
		private int value;
		
		private Type(int value){
			this.value = value;
		}
		
		public int value(){
			return value;
		}
	}
	
	private CountDownLatch handle = new CountDownLatch(1);
	
	private String peer;
	private Type type;
	
	private Object value;
	
	public PendingPeerOperation(Type type, String peer){
		this.type = type;
		this.peer = peer;
	}
	
	public <T> T waitOperation(long timeout) throws MediaException{
		try {
			if (!handle.await(timeout, TimeUnit.MILLISECONDS)){
				throw new MediaException("Timeout reached while waiting for operation: %s for peer: %s".format(type.name(), peer));
			}
		} catch (InterruptedException e) {
			throw new MediaException("Interruption while waiting for operation: %s for peer: %s".format(type.name(), peer));
		}
		
		return value != null ? (T)value : null;
	}
	
	public boolean tryUnlock(Type type, String peer, Object value){
		if (this.type != type || !this.peer.equals(peer)){
			return false;
		}
		
		this.value = value;
		handle.countDown();
		
		return true;
	}
	
	private boolean equals(PendingPeerOperation operation){
		if (operation == this){
			return true;
		}
		
		if (this.type == operation.type && this.peer == operation.peer){
			return true;
		}
		
		return false;
	}
	
	@Override
	public boolean equals(Object value){
		if (value != null){		
			if(value instanceof PendingPeerOperation){
				return equals((PendingPeerOperation)value);
			}			
		}
				
		return false;
	}
	
	@Override
	public int hashCode(){
		return (type.value() * 397) ^ (peer != null ? peer.hashCode() : 0);
	}
}
