/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.voiceengine;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.AudioTrack;
import android.os.Build;
import android.util.Log;
import org.webrtc.voiceengine.WebRtcAudioEffects;
import org.webrtc.voiceengine.WebRtcAudioUtils;

public class WebRtcAudioManager {
    private static final boolean DEBUG = false;
    private static final String TAG = "WebRtcAudioManager";
    private static boolean blacklistDeviceForOpenSLESUsage = false;
    private static boolean blacklistDeviceForOpenSLESUsageIsOverridden = false;
    private static final int BITS_PER_SAMPLE = 16;
    private static final int DEFAULT_FRAME_PER_BUFFER = 640;
    private static final int CHANNELS = 2;
    private static final String[] AUDIO_MODES = new String[]{"MODE_NORMAL", "MODE_RINGTONE", "MODE_IN_CALL", "MODE_IN_COMMUNICATION"};
    private final long nativeAudioManager;
    private final Context context;
    private final AudioManager audioManager;
    private boolean initialized = false;
    private int nativeSampleRate;
    private int nativeChannels;
    private boolean hardwareAEC;
    private boolean hardwareAGC;
    private boolean hardwareNS;
    private boolean lowLatencyOutput;
    private int sampleRate;
    private int channels;
    private int outputBufferSize;
    private int inputBufferSize;

    public static synchronized void setBlacklistDeviceForOpenSLESUsage(boolean enable) {
        blacklistDeviceForOpenSLESUsageIsOverridden = true;
        blacklistDeviceForOpenSLESUsage = enable;
    }

    WebRtcAudioManager(Context context, long nativeAudioManager) {
        Log.d((String)TAG, (String)("ctor" + WebRtcAudioUtils.getThreadInfo()));
        this.context = context;
        this.nativeAudioManager = nativeAudioManager;
        this.audioManager = (AudioManager)context.getSystemService("audio");
        this.storeAudioParameters();
        this.nativeCacheAudioParameters(this.sampleRate, this.channels, this.hardwareAEC, this.hardwareAGC, this.hardwareNS, this.lowLatencyOutput, this.outputBufferSize, this.inputBufferSize, nativeAudioManager);
    }

    private boolean init() {
        Log.d((String)TAG, (String)("init" + WebRtcAudioUtils.getThreadInfo()));
        if (this.initialized) {
            return true;
        }
        Log.d((String)TAG, (String)("audio mode is: " + AUDIO_MODES[this.audioManager.getMode()]));
        this.initialized = true;
        return true;
    }

    private void dispose() {
        Log.d((String)TAG, (String)("dispose" + WebRtcAudioUtils.getThreadInfo()));
        if (!this.initialized) {
            return;
        }
    }

    private boolean isCommunicationModeEnabled() {
        return this.audioManager.getMode() == 3;
    }

    private boolean isDeviceBlacklistedForOpenSLESUsage() {
        boolean blacklisted;
        boolean bl = blacklisted = blacklistDeviceForOpenSLESUsageIsOverridden ? blacklistDeviceForOpenSLESUsage : WebRtcAudioUtils.deviceIsBlacklistedForOpenSLESUsage();
        if (blacklisted) {
            Log.e((String)TAG, (String)(Build.MODEL + " is blacklisted for OpenSL ES usage!"));
        }
        return blacklisted;
    }

    private void storeAudioParameters() {
        this.channels = 2;
        this.sampleRate = this.getNativeOutputSampleRate();
        this.hardwareAEC = WebRtcAudioManager.isAcousticEchoCancelerSupported();
        this.hardwareAGC = WebRtcAudioManager.isAutomaticGainControlSupported();
        this.hardwareNS = WebRtcAudioManager.isNoiseSuppressorSupported();
        this.lowLatencyOutput = false;
        this.outputBufferSize = this.lowLatencyOutput ? this.getLowLatencyOutputFramesPerBuffer() : WebRtcAudioManager.getMinOutputFrameSize(this.sampleRate, this.channels);
        this.inputBufferSize = WebRtcAudioManager.getMinInputFrameSize(this.sampleRate, 2);
    }

    private boolean hasEarpiece() {
        return this.context.getPackageManager().hasSystemFeature("android.hardware.telephony");
    }

    private boolean isLowLatencyOutputSupported() {
        return WebRtcAudioManager.isOpenSLESSupported() && this.context.getPackageManager().hasSystemFeature("android.hardware.audio.low_latency");
    }

    public boolean isLowLatencyInputSupported() {
        return false;
    }

    private int getNativeOutputSampleRate() {
        if (WebRtcAudioUtils.runningOnEmulator()) {
            Log.d((String)TAG, (String)"Running emulator, overriding sample rate to 8 kHz.");
            return 8000;
        }
        if (WebRtcAudioUtils.isDefaultSampleRateOverridden()) {
            Log.d((String)TAG, (String)("Default sample rate is overriden to " + WebRtcAudioUtils.getDefaultSampleRateHz() + " Hz"));
            return WebRtcAudioUtils.getDefaultSampleRateHz();
        }
        int sampleRateHz = WebRtcAudioUtils.runningOnJellyBeanMR1OrHigher() ? this.getSampleRateOnJellyBeanMR10OrHigher() : WebRtcAudioUtils.getDefaultSampleRateHz();
        Log.d((String)TAG, (String)("Sample rate is set to " + sampleRateHz + " Hz"));
        return sampleRateHz;
    }

    @TargetApi(value=17)
    private int getSampleRateOnJellyBeanMR10OrHigher() {
        String sampleRateString = this.audioManager.getProperty("android.media.property.OUTPUT_SAMPLE_RATE");
        return sampleRateString == null ? WebRtcAudioUtils.getDefaultSampleRateHz() : Integer.parseInt(sampleRateString);
    }

    @TargetApi(value=17)
    private int getLowLatencyOutputFramesPerBuffer() {
        if (!WebRtcAudioUtils.runningOnJellyBeanMR1OrHigher()) {
            return 640;
        }
        String framesPerBuffer = this.audioManager.getProperty("android.media.property.OUTPUT_FRAMES_PER_BUFFER");
        return framesPerBuffer == null ? 640 : Integer.parseInt(framesPerBuffer);
    }

    private static boolean isAcousticEchoCancelerSupported() {
        return false;
    }

    private static boolean isAutomaticGainControlSupported() {
        return WebRtcAudioEffects.canUseAutomaticGainControl();
    }

    private static boolean isNoiseSuppressorSupported() {
        return WebRtcAudioEffects.canUseNoiseSuppressor();
    }

    private static int getMinOutputFrameSize(int sampleRateInHz, int numChannels) {
        int channelConfig;
        int bytesPerFrame = numChannels * 2;
        if (numChannels == 1) {
            channelConfig = 4;
        } else if (numChannels == 2) {
            channelConfig = 12;
        } else {
            return -1;
        }
        return AudioTrack.getMinBufferSize((int)sampleRateInHz, (int)channelConfig, (int)2) / bytesPerFrame;
    }

    private int getLowLatencyInputFramesPerBuffer() {
        WebRtcAudioManager.assertTrue(this.isLowLatencyInputSupported());
        return this.getLowLatencyOutputFramesPerBuffer();
    }

    private static int getMinInputFrameSize(int sampleRateInHz, int numChannels) {
        int bytesPerFrame = numChannels * 2;
        return AudioRecord.getMinBufferSize((int)sampleRateInHz, (int)16, (int)2) / bytesPerFrame;
    }

    private static boolean isOpenSLESSupported() {
        return WebRtcAudioUtils.runningOnGingerBreadOrHigher();
    }

    private static void assertTrue(boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    public static boolean IsAndroidStreamMusic() {
        int apiLevel = Build.VERSION.SDK_INT;
        return Build.BRAND.equals("Samsung") || Build.BRAND.equals("samsung");
    }

    public static boolean ISAndroidVoiceCall() {
        int apiLevel = Build.VERSION.SDK_INT;
        return apiLevel < 22 && apiLevel > 18 && (Build.BRAND.equals("Samsung") || Build.BRAND.equals("samsung"));
    }

    private native void nativeCacheAudioParameters(int var1, int var2, boolean var3, boolean var4, boolean var5, boolean var6, int var7, int var8, long var9);
}

