package com.voxeet.android.media;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.media.AudioManager;
import android.net.wifi.WifiManager;
import android.net.wifi.WifiManager.WifiLock;
import android.os.Build;
import android.os.PowerManager;
import android.os.PowerManager.WakeLock;
import android.util.Log;

/**
 * Class that manage the difference WakeLock required for the conference.
 * 
 * @author Thomas Gourgues
 */
public class MediaPowerManager {
	private static final String TAG = MediaPowerManager.class.getSimpleName();
	private static final int    PROXIMITY_SCREEN_OFF_WAKE_LOCK = 32;
	
	private Context       mContext;
	
	private PowerManager  mPowerManager;
	private WifiManager   mWifiManager;
	
	private WakeLock      mProximityWakeLock;
	private WakeLock      mPartialWakeLock;
	private WifiLock      mWifiLock;
	
	public MediaPowerManager(Context context) {
		mContext = context;
		mPowerManager = (PowerManager)mContext.getSystemService(Context.POWER_SERVICE);
		mWifiManager = (WifiManager)mContext.getSystemService(Context.WIFI_SERVICE);

		try{
			mProximityWakeLock = mPowerManager.newWakeLock(PROXIMITY_SCREEN_OFF_WAKE_LOCK, TAG);
			mPartialWakeLock = mPowerManager.newWakeLock(PowerManager.PARTIAL_WAKE_LOCK, TAG);
			mWifiLock = mWifiManager.createWifiLock(WifiManager.WIFI_MODE_FULL_HIGH_PERF, TAG);
		}catch(Exception e){
			Log.e(TAG, "Failed to create required WakeLock");
		}
	}
	
	public void aquire(){
		
		if (!mPartialWakeLock.isHeld()){
			mPartialWakeLock.acquire();
		}
		
		if (!mWifiLock.isHeld()){
			mWifiLock.acquire();
		}
	}
	
	public void release(){

		
		if (mPartialWakeLock.isHeld()){
			mPartialWakeLock.release();
		}
		
		if (mWifiLock.isHeld()){
			mWifiLock.release();
		}
	}

    public void aquireProximity(){
        String model = Build.BRAND;
        if (!model.toLowerCase().contains("samsung")){
            if (!mProximityWakeLock.isHeld()){
                mProximityWakeLock.acquire();
            }
        }
    }

    public void releaseProximity(){
        if (mProximityWakeLock.isHeld()){
            mProximityWakeLock.release();
        }
    }
}
