package com.voxeet.android.media;

public class ConferenceSettings{
	public interface OnChangedListener{
		public void onSpeakerModeChanged(boolean isEnabled);
		public void onHDModeChanged(boolean isEnabled);
		
	}
	
	private OnChangedListener m_onChangeListener;
	
	public ConferenceSettings(){
		m_onChangeListener = null;
	}
	
	public void registerOnChangedListener(ConferenceSettings.OnChangedListener listener){
		m_onChangeListener = listener;
	}
	
	public void unregisterOnChangedListener(){
		m_onChangeListener = null;
	}
	
	public void onSpeakerModeChanged(boolean isEnabled){
		if (m_onChangeListener != null){
			m_onChangeListener.onSpeakerModeChanged(isEnabled);
		}
	}
	
	public void onHDModeChanged(boolean isEnabled){
		if (m_onChangeListener != null){
			m_onChangeListener.onHDModeChanged(isEnabled);
		}
	}
}