/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.android.media;

import com.voxeet.android.media.MediaException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class PendingPeerOperation {
    private CountDownLatch handle = new CountDownLatch(1);
    private String peer;
    private Type type;
    private Object value;

    public PendingPeerOperation(Type type, String peer) {
        this.type = type;
        this.peer = peer;
    }

    public <T> T waitOperation(long timeout) throws MediaException {
        try {
            if (!this.handle.await(timeout, TimeUnit.MILLISECONDS)) {
                throw new MediaException(String.format(this.type.name(), this.peer));
            }
        }
        catch (InterruptedException e) {
            throw new MediaException(String.format(this.type.name(), this.peer));
        }
        return (T)(this.value != null ? this.value : null);
    }

    public boolean tryUnlock(Type type, String peer, Object value) {
        if (this.type != type || !this.peer.equals(peer)) {
            return false;
        }
        this.value = value;
        this.handle.countDown();
        return true;
    }

    private boolean equals(PendingPeerOperation operation) {
        if (operation == this) {
            return true;
        }
        return this.type == operation.type && this.peer == operation.peer;
    }

    public boolean equals(Object value) {
        if (value != null && value instanceof PendingPeerOperation) {
            return this.equals((PendingPeerOperation)value);
        }
        return false;
    }

    public int hashCode() {
        return this.type.value() * 397 ^ (this.peer != null ? this.peer.hashCode() : 0);
    }

    public static enum Type {
        OFFER(0),
        ANSWER(1),
        CANDIDATES(2);

        private int value;

        private Type(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }
    }
}

