package com.voxeet.android.media.settings;

import java.net.InetSocketAddress;

public class AudioSettings {
	private String   stunHost;	
	private int      stunPort;
	
	private boolean  noiseSuppressionEnabled;
	private boolean  automaticGainControlEnabled;
	private boolean  echoControlEnabled;
	private boolean  typingDetectionEnabled;

    private int delayMs;
	
	public AudioSettings(String stunHost, int stunPort){
		this.stunHost = stunHost;
		this.stunPort = stunPort;
		this.noiseSuppressionEnabled = true;
		this.automaticGainControlEnabled = true;
		this.echoControlEnabled = true;
		this.typingDetectionEnabled = false;
        this.delayMs = 0;
	}
	
	public AudioSettings(String stunHost, int stunPort, boolean ns, boolean ag, boolean ec, boolean td){
		this.noiseSuppressionEnabled = ns;
		this.automaticGainControlEnabled = ag;
		this.echoControlEnabled = ec;
		this.typingDetectionEnabled = td;
	}

	public String stunHost(){
		InetSocketAddress address = new InetSocketAddress(stunHost, stunPort);		
		return address.toString();
	}
	
	public boolean noiseSuppressionEnabled(){
		return noiseSuppressionEnabled;
	}
	
	public void setNoiseSuppressionEnabled(boolean enabled){
		this.noiseSuppressionEnabled = enabled;
	}
	
	public boolean automaticGainControlEnabled(){
		return automaticGainControlEnabled;
	}
	
	public void setAutomaticGainControlEnabled(boolean enabled){
		this.automaticGainControlEnabled = enabled;
	}
	
	public boolean echoControlEnabled(){
		return echoControlEnabled;
	}
	
	public void setEchoControlEnabled(boolean enabled){
		this.echoControlEnabled = enabled;
	}
	
	public boolean typingDetectionEnabled(){
		return typingDetectionEnabled;
	}
	
	public void setTypingDetectionEnabled(boolean enabled){
		this.typingDetectionEnabled = enabled;
	}

    public int delayMs(){
        return delayMs;
    }

    public void setDelayMs(int delayMs){
        this.delayMs = delayMs;
    }
}
