package com.voxeet.android.media.peer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SdpCandidates {
	private Map<String, List<SdpCandidate>> candidates;
	
	public SdpCandidates(){
		candidates = new HashMap<String, List<SdpCandidate>>();
	}
	
	public void add(String peer, SdpCandidate candidate){
		if (candidates.containsKey(peer)){
			candidates.get(peer).add(candidate);
		}else{
			List<SdpCandidate> candList = new ArrayList<SdpCandidate>();
			candList.add(candidate);
			candidates.put(peer, candList);
		}
	}
	
	public List<SdpCandidate> candidates(String peer){
		if (!candidates.containsKey(peer)){
			List<SdpCandidate> candList = new ArrayList<SdpCandidate>();			
			candidates.put(peer, candList);
		}
		
		return this.candidates.get(peer);
	}
}
