/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.android.media.video;

import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.os.Build;
import android.os.SystemClock;
import android.util.Log;
import android.util.Range;
import android.util.Size;
import com.voxeet.android.media.video.CameraEnumerationAndroid;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@TargetApi(value=21)
public class Camera2Enumerator
implements CameraEnumerationAndroid.Enumerator {
    private static final String TAG = "Camera2Enumerator";
    private static final double NANO_SECONDS_PER_SECOND = 1.0E9;
    private final CameraManager cameraManager;
    private final Map<Integer, List<CameraEnumerationAndroid.CaptureFormat>> cachedSupportedFormats = new HashMap<Integer, List<CameraEnumerationAndroid.CaptureFormat>>();

    public static boolean isSupported() {
        return Build.VERSION.SDK_INT >= 21;
    }

    public Camera2Enumerator(Context context) {
        this.cameraManager = (CameraManager)context.getSystemService("camera");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CameraEnumerationAndroid.CaptureFormat> getSupportedFormats(int cameraId) {
        Map<Integer, List<CameraEnumerationAndroid.CaptureFormat>> map = this.cachedSupportedFormats;
        synchronized (map) {
            CameraCharacteristics cameraCharacteristics;
            if (this.cachedSupportedFormats.containsKey(cameraId)) {
                return this.cachedSupportedFormats.get(cameraId);
            }
            Log.d((String)TAG, (String)("Get supported formats for camera index " + cameraId + ""));
            long startTimeMs = SystemClock.elapsedRealtime();
            try {
                cameraCharacteristics = this.cameraManager.getCameraCharacteristics(Integer.toString(cameraId));
            }
            catch (Exception ex) {
                Log.e((String)TAG, (String)("getCameraCharacteristics(): " + ex));
                return new ArrayList<CameraEnumerationAndroid.CaptureFormat>();
            }
            Range[] fpsRanges = (Range[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
            int defaultMaxFps = 0;
            for (Range fpsRange : fpsRanges) {
                defaultMaxFps = Math.max(defaultMaxFps, (Integer)fpsRange.getUpper());
            }
            StreamConfigurationMap streamMap = (StreamConfigurationMap)cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            Size[] sizes = streamMap.getOutputSizes(35);
            if (sizes == null) {
                throw new RuntimeException("ImageFormat.YUV_420_888 not supported.");
            }
            ArrayList<CameraEnumerationAndroid.CaptureFormat> formatList = new ArrayList<CameraEnumerationAndroid.CaptureFormat>();
            for (Size size : sizes) {
                long minFrameDurationNs = 0L;
                try {
                    minFrameDurationNs = streamMap.getOutputMinFrameDuration(35, size);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int maxFps = minFrameDurationNs == 0L ? defaultMaxFps : (int)Math.round(1.0E9 / (double)minFrameDurationNs);
                formatList.add(new CameraEnumerationAndroid.CaptureFormat(size.getWidth(), size.getHeight(), 0, maxFps * 1000));
            }
            this.cachedSupportedFormats.put(cameraId, formatList);
            long endTimeMs = SystemClock.elapsedRealtime();
            Log.d((String)TAG, (String)("Get supported formats for camera index " + cameraId + " done." + " Time spent: " + (endTimeMs - startTimeMs) + " ms."));
            return formatList;
        }
    }
}

