/*
 * Decompiled with CFR 0.152.
 */
package com.voxeet.android.media;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.os.Build;
import android.util.Log;
import com.voxeet.android.media.LooperExecutor;
import com.voxeet.android.media.MediaException;
import com.voxeet.android.media.MediaPowerManager;
import com.voxeet.android.media.MediaStream;
import com.voxeet.android.media.PendingPeerOperation;
import com.voxeet.android.media.VideoRenderer;
import com.voxeet.android.media.peer.SdpCandidate;
import com.voxeet.android.media.peer.SdpCandidates;
import com.voxeet.android.media.peer.SdpDescription;
import com.voxeet.android.media.peer.SdpMessage;
import com.voxeet.android.media.settings.AudioSettings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.webrtc.voiceengine.WebRtcAudioUtils;

public class Media {
    public static final String TAG = Media.class.getSimpleName();
    public static final String MEDIA_OUPUT_ROUTE_INTENT = "media-output-route-intent";
    private static AtomicBoolean registered = new AtomicBoolean(false);
    private Object operationLock = new Object();
    private Object candidateLock = new Object();
    private static Context context;
    private AudioManager audioManager;
    private String peer;
    private AudioSettings settings;
    private SdpCandidates peerCandidates;
    private List<PendingPeerOperation> peerOperations;
    private long descriptionTimeout = 5000L;
    private long candidatesTimeout = 5000L;
    private MediaPowerManager powerManager;
    private MediaStateListener mediaStateListener;
    private MediaStreamListener mediaStreamListener;
    private HeadsetStateReceiver headsetStateReceiver;
    private BluetoothHeadsetListener bluetoothHeadsetListener;
    private BluetoothAdapter bluetoothAdapter;
    private BluetoothHeadset bluetoothHeadset;
    private AudioRoute outputRoute;
    private Map<String, VideoRenderer> renderers;
    private boolean bluetoothScoStarted;
    private boolean isMuted = false;
    private LooperExecutor executor;

    public static Context context() {
        return context;
    }

    public Media(Context context) {
        Media.context = context;
    }

    public Media(String peer, Context context, AudioSettings settings) throws MediaException {
        this.peer = peer;
        this.settings = settings;
        this.mediaStateListener = null;
        this.mediaStreamListener = null;
        Media.context = context;
        this.powerManager = new MediaPowerManager(context);
        this.headsetStateReceiver = new HeadsetStateReceiver();
        this.bluetoothHeadsetListener = new BluetoothHeadsetListener();
        this.bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        this.bluetoothHeadset = null;
        this.bluetoothScoStarted = false;
        this.powerManager.aquire();
        this.peerOperations = new ArrayList<PendingPeerOperation>();
        this.peerCandidates = new SdpCandidates();
        this.renderers = new HashMap<String, VideoRenderer>();
        this.audioManager = (AudioManager)context.getSystemService("audio");
        context.registerReceiver((BroadcastReceiver)this.headsetStateReceiver, new IntentFilter("android.intent.action.HEADSET_PLUG"));
        this.bluetoothAdapter.getProfileProxy(context, (BluetoothProfile.ServiceListener)this.bluetoothHeadsetListener, 1);
        this.executor = new LooperExecutor();
        this.executor.requestStart();
        WebRtcAudioUtils.setDefaultSampleRateHz(16000);
        if (!this.Init(peer, settings)) {
            throw new MediaException("An error occurred during init");
        }
        if (this.audioManager.isWiredHeadsetOn()) {
            this.setSpeakerMode(false);
        } else {
            this.setSpeakerMode(true);
        }
    }

    public void stop() {
        this.setBluetooth(false);
        context.unregisterReceiver((BroadcastReceiver)this.headsetStateReceiver);
        if (this.bluetoothHeadset != null) {
            this.bluetoothAdapter.closeProfileProxy(1, (BluetoothProfile)this.bluetoothHeadset);
        }
        this.powerManager.release();
        this.powerManager.releaseProximity();
        this.Release();
        this.audioManager.setSpeakerphoneOn(true);
        this.audioManager.setMode(0);
        this.executor.requestStop();
    }

    public void registerListener(MediaStateListener listener) {
        this.mediaStateListener = listener;
    }

    public void unregisterListener() {
        this.mediaStateListener = null;
    }

    public void setMediaStreamListener(MediaStreamListener listener) {
        this.mediaStreamListener = listener;
    }

    public AudioRoute outputRoute() {
        return this.outputRoute;
    }

    public boolean isBluetoothHeadsetOn() {
        return this.bluetoothHeadset != null;
    }

    public boolean isWiredHeadsetOn() {
        return this.audioManager.isWiredHeadsetOn();
    }

    public void setBluetooth(boolean isEnabled) {
        try {
            if (isEnabled) {
                if (!this.bluetoothScoStarted) {
                    this.audioManager.startBluetoothSco();
                    this.bluetoothScoStarted = true;
                }
            } else if (this.bluetoothScoStarted) {
                this.audioManager.stopBluetoothSco();
                this.bluetoothScoStarted = false;
            }
        }
        catch (NullPointerException e) {
            Log.d((String)TAG, (String)"No bluetooth headset connected");
        }
        this.checkOutputRoute();
        this.checkProximitySensor();
    }

    public void setSpeakerMode(boolean speakerMode) {
        this.setBluetooth(false);
        if (Build.BRAND.equals("Samsung") || Build.BRAND.equals("samsung")) {
            int requiredSpeakerMode = 3;
            if (speakerMode) {
                this.audioManager.setSpeakerphoneOn(true);
                this.audioManager.setMode(-1);
            } else {
                this.audioManager.setSpeakerphoneOn(speakerMode);
                if (this.audioManager.isWiredHeadsetOn()) {
                    this.audioManager.setMode(-1);
                } else {
                    this.audioManager.setMode(requiredSpeakerMode);
                }
            }
        } else {
            this.audioManager.setSpeakerphoneOn(speakerMode);
        }
        if (this.mediaStateListener != null) {
            this.mediaStateListener.OnSpeakerChanged(speakerMode);
        }
        this.checkOutputRoute();
        this.checkProximitySensor();
    }

    protected void checkProximitySensor() {
        if (this.outputRoute == AudioRoute.ROUTE_PHONE) {
            this.powerManager.aquireProximity();
        } else {
            this.powerManager.releaseProximity();
        }
    }

    protected void checkOutputRoute() {
        this.outputRoute = this.bluetoothScoStarted ? AudioRoute.ROUTE_BLUETOOTH : (this.audioManager.isSpeakerphoneOn() ? AudioRoute.ROUTE_SPEAKER : (this.audioManager.isWiredHeadsetOn() ? AudioRoute.ROUTE_HEADSET : AudioRoute.ROUTE_PHONE));
        Intent intent = new Intent(MEDIA_OUPUT_ROUTE_INTENT);
        intent.putExtra("route", this.outputRoute.value());
        context.sendBroadcast(intent);
    }

    public void setOutputRoute(AudioRoute route) {
        switch (route) {
            case ROUTE_HEADSET: 
            case ROUTE_PHONE: {
                this.setSpeakerMode(false);
                break;
            }
            case ROUTE_SPEAKER: {
                this.setSpeakerMode(true);
                break;
            }
            case ROUTE_BLUETOOTH: {
                this.setBluetooth(true);
                break;
            }
        }
    }

    public List<AudioRoute> availableRoutes() {
        ArrayList<AudioRoute> routes = new ArrayList<AudioRoute>();
        routes.add(AudioRoute.ROUTE_SPEAKER);
        if (this.isWiredHeadsetOn()) {
            routes.add(AudioRoute.ROUTE_HEADSET);
        } else {
            routes.add(AudioRoute.ROUTE_PHONE);
        }
        if (this.isBluetoothHeadsetOn()) {
            routes.add(AudioRoute.ROUTE_BLUETOOTH);
        }
        return routes;
    }

    public int calibrate(String sound) {
        int delay = this.Calibrate(context, sound);
        return delay;
    }

    public void attachMediaStream(String peer, MediaStream stream, VideoRenderer.Callbacks callbacks) {
        if (!this.renderers.containsKey(peer)) {
            VideoRenderer renderer = new VideoRenderer(callbacks);
            this.renderers.put(peer, renderer);
            this.AttachMediaStream(peer, stream.nativeStream, renderer.nativeVideoRenderer);
        }
    }

    public void unattachMediaStream(String peer, MediaStream stream) {
        if (this.renderers.containsKey(peer)) {
            VideoRenderer renderer = this.renderers.get(peer);
            this.renderers.remove(renderer);
            this.UnAttachMediaStream(peer, stream.nativeStream, renderer.nativeVideoRenderer);
        }
    }

    public SdpMessage createOfferForPeer(String peer, boolean master) throws MediaException {
        this.createConnection(peer, master);
        if (!this.CreateOffer(peer)) {
            throw new MediaException(String.format("Unable to create offer for Peer: %s", peer));
        }
        return this.WaitForSdpMessage(peer, PendingPeerOperation.Type.OFFER);
    }

    public SdpMessage createAnswerForPeer(String peer, long ssrc, SdpDescription offer, List<SdpCandidate> offerCandidates, boolean isMaster) throws MediaException {
        this.createConnection(peer, isMaster);
        if (!this.SetPeerDescription(peer, ssrc, offer.getType(), offer.getSdp())) {
            throw new MediaException(String.format("Unable set remote SDP for Peer: %s", peer));
        }
        Iterator<SdpCandidate> i$ = offerCandidates.iterator();
        while (i$.hasNext()) {
            SdpCandidate candidate;
            SdpCandidate c = candidate = i$.next();
            this.SetPeerCandidate(peer, c.getSdpMid(), c.getSdpMLineIndex(), c.getSdp());
        }
        if (!this.CreateAnswer(peer)) {
            throw new MediaException(String.format("Unable to create answer for Peer: %s", peer));
        }
        return this.WaitForSdpMessage(peer, PendingPeerOperation.Type.ANSWER);
    }

    public void addPeerFromAnswer(String peer, long ssrc, SdpDescription answer, List<SdpCandidate> candidates) throws MediaException {
        if (!this.SetPeerDescription(peer, ssrc, answer.getType(), answer.getSdp())) {
            throw new MediaException(String.format("Unable set remote SDP for Peer: %s", peer));
        }
        for (SdpCandidate candidate : candidates) {
            this.SetPeerCandidate(peer, candidate.getSdpMid(), candidate.getSdpMLineIndex(), candidate.getSdp());
        }
    }

    public void removePeer(String peer) {
        if (!this.ClosePeerConnection(peer)) {
            Log.w((String)TAG, (String)String.format("Unable to close peer connection for peer: %s", peer));
        }
    }

    public void changePeerPosition(String peer, double angle, double distance) {
        if (!this.SetPeerPosition(peer, angle, distance)) {
            Log.w((String)TAG, (String)String.format("Unable to change position for peer: %s", peer));
        }
    }

    public void changePeerPosition(String peer, double angle, double distance, float gain) {
        if (!this.SetPeerPositionGain(peer, angle, distance, gain)) {
            Log.w((String)TAG, (String)String.format("Unable to change position for peer: %s", peer));
        }
    }

    public void changePeerGain(String peer, float gain) {
        if (this.SetPeerGain(peer, gain)) {
            Log.w((String)TAG, (String)String.format("Unable to change gain for peer: {0}", peer));
        }
    }

    public void muteRecording() {
        this.isMuted = true;
        this.SetMute(true);
    }

    public void unMuteRecording() {
        this.isMuted = false;
        this.SetMute(false);
    }

    public boolean isMuted() {
        return this.isMuted;
    }

    public int getLocalVuMeter() {
        return this.GetLocalVuMeter();
    }

    public int getPeerVuMeter(String peer) {
        return this.GetPeerVuMeter(peer);
    }

    public boolean setCodecQuality(int quality) {
        return this.SetCodecQuality(quality);
    }

    public boolean pstnNeeded() {
        return this.PstnNeeded();
    }

    public boolean resetAudioDevice() {
        return this.ResetAudioDevice();
    }

    public void onSessionCreated(String peer, String type, String sdp) {
        PendingPeerOperation.Type operationType;
        Log.d((String)TAG, (String)String.format("Session description received for peer: %s with type: %s and SDP: %s", peer, type, sdp));
        if (type.equals("offer")) {
            operationType = PendingPeerOperation.Type.OFFER;
        } else if (type.equals("answer")) {
            operationType = PendingPeerOperation.Type.ANSWER;
        } else {
            Log.w((String)TAG, (String)String.format("Session description received from an unknown type: %s", type));
            return;
        }
        this.unlockPeerOperation(operationType, peer, new SdpDescription(type, sdp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onIceCandidateDiscovered(String peer, String sdpMid, int sdpMLineIndex, String sdp) {
        Log.d((String)TAG, (String)String.format("ICE candidate discovered for peer: %s with id: %s and SDP: %s", peer, sdpMid, sdp));
        Object object = this.candidateLock;
        synchronized (object) {
            this.peerCandidates.add(peer, new SdpCandidate(sdpMid, sdpMLineIndex, sdp));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onIceGatheringComplete(String peer) {
        List<SdpCandidate> candidates;
        Log.d((String)TAG, (String)String.format("ICE candidate gathering complete for peer: %s", peer));
        Object object = this.candidateLock;
        synchronized (object) {
            candidates = this.peerCandidates.candidates(peer);
        }
        if (candidates.isEmpty()) {
            Log.w((String)TAG, (String)String.format("No ICE candidate gathered for peer: %s", peer));
        }
        this.unlockPeerOperation(PendingPeerOperation.Type.CANDIDATES, peer, candidates);
    }

    public void onStreamAdded(String peer, MediaStream stream) {
        Log.d((String)TAG, (String)"Java stream added");
        if (this.mediaStreamListener != null) {
            this.mediaStreamListener.onStreamAdded(peer, stream);
        }
    }

    public void onStreamRemoved(String peer, MediaStream stream) {
        Log.d((String)TAG, (String)"Java stream removed");
        if (this.mediaStreamListener != null) {
            this.mediaStreamListener.onStreamRemoved(peer, stream);
        }
    }

    public void onScreenStreamAdded(String peer, MediaStream stream) {
        Log.d((String)TAG, (String)"Java stream added");
        Log.e((String)TAG, (String)("Java Media stream ptr value: " + stream.nativeStream));
        if (this.mediaStreamListener != null) {
            this.mediaStreamListener.onScreenStreamAdded(peer, stream);
        }
    }

    public void onScreenStreamRemoved(String peer, MediaStream stream) {
        Log.d((String)TAG, (String)"Java stream removed");
        if (this.mediaStreamListener != null) {
            this.mediaStreamListener.onScreenStreamRemoved(peer, stream);
        }
    }

    private void createConnection(String peer, boolean master) throws MediaException {
        if (!this.CreatePeerConnection(peer, master)) {
            throw new MediaException(String.format("Unable to create connection with Peer: %s", peer));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PendingPeerOperation createPeerOperation(PendingPeerOperation.Type type, String peer) throws MediaException {
        PendingPeerOperation operation = new PendingPeerOperation(type, peer);
        Object object = this.operationLock;
        synchronized (object) {
            if (this.peerOperations.contains(operation)) {
                throw new MediaException(String.format("An operation of type: %s is already pending for peer: %s", type.name(), peer));
            }
        }
        this.peerOperations.add(operation);
        return operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockPeerOperation(PendingPeerOperation.Type type, String peer, Object value) {
        Object object = this.operationLock;
        synchronized (object) {
            boolean isFound = false;
            for (PendingPeerOperation operation : this.peerOperations) {
                if (!operation.tryUnlock(type, peer, value)) continue;
                isFound = true;
                this.peerOperations.remove(operation);
                break;
            }
            if (!isFound) {
                Log.w((String)TAG, (String)String.format("No pending operation found for peer: %s with type: %s", peer, type.name()));
            }
        }
    }

    private SdpMessage WaitForSdpMessage(String peer, PendingPeerOperation.Type type) throws MediaException {
        PendingPeerOperation descriptionOperation = this.createPeerOperation(type, peer);
        SdpDescription answer = (SdpDescription)descriptionOperation.waitOperation(this.descriptionTimeout);
        return new SdpMessage(answer, Collections.emptyList());
    }

    public void MuteConference(boolean shouldMute) {
        if (this.isMuted != shouldMute) {
            this.isMuted = shouldMute;
            this.SetMute(this.isMuted);
        }
    }

    public static void Register(Context context) {
        if (!registered.get()) {
            Media.register(context);
        }
        registered.set(true);
    }

    public static void UnRegister() {
        Media.unRegister();
        registered.set(false);
    }

    public static native void register(Context var0);

    public static native void unRegister();

    private native boolean Init(String var1, AudioSettings var2);

    private native void Release();

    private native void AttachMediaStream(String var1, long var2, long var4);

    private native void UnAttachMediaStream(String var1, long var2, long var4);

    private native boolean CreatePeerConnection(String var1, boolean var2);

    private native boolean ClosePeerConnection(String var1);

    private native boolean CreateOffer(String var1);

    private native boolean CreateAnswer(String var1);

    private native boolean SetPeerDescription(String var1, long var2, String var4, String var5);

    private native boolean SetPeerCandidate(String var1, String var2, int var3, String var4);

    private native boolean SetPeerPosition(String var1, double var2, double var4);

    private native boolean SetPeerPositionGain(String var1, double var2, double var4, float var6);

    private native boolean SetPeerGain(String var1, float var2);

    private native void SetMute(boolean var1);

    private native void SetAudioOptions(boolean var1, boolean var2, boolean var3, boolean var4);

    private native int GetLocalVuMeter();

    private native int GetPeerVuMeter(String var1);

    private native boolean SetCodecQuality(int var1);

    private native boolean SetOpusCustomProperties(int var1, int var2);

    private native boolean DecreasePeersQuality();

    private native boolean PstnNeeded();

    public native int Calibrate(Context var1, String var2);

    public native boolean ResetAudioDevice();

    static {
        try {
            System.loadLibrary("media-jni");
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.getMessage());
        }
    }

    private class BluetoothHeadsetListener
    implements BluetoothProfile.ServiceListener {
        private BluetoothHeadsetListener() {
        }

        public void onServiceConnected(int i, BluetoothProfile bluetoothProfile) {
            Media.this.bluetoothHeadset = (BluetoothHeadset)bluetoothProfile;
            if (Media.this.mediaStateListener != null) {
                Media.this.mediaStateListener.onBluetoothHeadsetStateChange(true);
            }
        }

        public void onServiceDisconnected(int i) {
            Media.this.bluetoothHeadset = null;
            if (Media.this.mediaStateListener != null) {
                Media.this.mediaStateListener.onBluetoothHeadsetStateChange(false);
                Media.this.audioManager.stopBluetoothSco();
                Media.this.bluetoothScoStarted = false;
            }
            Media.this.checkOutputRoute();
            Media.this.checkProximitySensor();
        }
    }

    private class BluetoothStateReceiver
    extends BroadcastReceiver {
        private BluetoothStateReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if ("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED".equals(intent.getAction()) && Media.this.mediaStateListener != null) {
                int state = intent.getIntExtra("android.bluetooth.profile.extra.STATE", -1);
                switch (state) {
                    case 0: {
                        Media.this.mediaStateListener.onBluetoothHeadsetStateChange(false);
                        break;
                    }
                    case 2: {
                        Media.this.mediaStateListener.onBluetoothHeadsetStateChange(true);
                        break;
                    }
                }
            }
        }
    }

    private class HeadsetStateReceiver
    extends BroadcastReceiver {
        private HeadsetStateReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.HEADSET_PLUG".equals(intent.getAction())) {
                int state = intent.getIntExtra("state", -1);
                switch (state) {
                    case 0: {
                        if (Media.this.mediaStateListener != null) {
                            Media.this.mediaStateListener.onHeadsetStateChange(false);
                        }
                        Media.this.setSpeakerMode(true);
                        break;
                    }
                    case 1: {
                        if (Media.this.mediaStateListener != null) {
                            Media.this.mediaStateListener.onHeadsetStateChange(true);
                        }
                        Media.this.setSpeakerMode(false);
                        break;
                    }
                }
            }
        }
    }

    public static interface MediaStreamListener {
        public void onStreamAdded(String var1, MediaStream var2);

        public void onStreamRemoved(String var1, MediaStream var2);

        public void onScreenStreamAdded(String var1, MediaStream var2);

        public void onScreenStreamRemoved(String var1, MediaStream var2);
    }

    public static interface MediaStateListener {
        public void OnSpeakerChanged(boolean var1);

        public void onHeadsetStateChange(boolean var1);

        public void onBluetoothHeadsetStateChange(boolean var1);
    }

    public static enum AudioRoute {
        ROUTE_HEADSET(0),
        ROUTE_PHONE(1),
        ROUTE_SPEAKER(2),
        ROUTE_BLUETOOTH(3);

        private int value;

        private AudioRoute(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public static AudioRoute valueOf(int value) {
            switch (value) {
                case 0: {
                    return ROUTE_HEADSET;
                }
                case 1: {
                    return ROUTE_PHONE;
                }
                case 2: {
                    return ROUTE_SPEAKER;
                }
                case 3: {
                    return ROUTE_BLUETOOTH;
                }
            }
            return ROUTE_SPEAKER;
        }
    }
}

