/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.voiceengine;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.AudioManager;
import android.media.AudioTrack;
import android.os.Process;
import android.util.Log;
import java.nio.ByteBuffer;
import org.webrtc.voiceengine.WebRtcAudioManager;
import org.webrtc.voiceengine.WebRtcAudioUtils;

class WebRtcAudioTrack {
    private static final boolean DEBUG = false;
    private static final String TAG = "WebRtcAudioTrack";
    private static final int BITS_PER_SAMPLE = 16;
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final int BUFFERS_PER_SECOND = 100;
    private final Context context;
    private final long nativeAudioTrack;
    private final AudioManager audioManager;
    private ByteBuffer byteBuffer;
    private AudioTrack audioTrack = null;
    private AudioTrackThread audioThread = null;

    WebRtcAudioTrack(Context context, long nativeAudioTrack) {
        Log.d((String)TAG, (String)("ctor" + WebRtcAudioUtils.getThreadInfo()));
        this.context = context;
        this.nativeAudioTrack = nativeAudioTrack;
        this.audioManager = (AudioManager)context.getSystemService("audio");
    }

    private boolean initPlayout(int sampleRate, int channels) {
        Log.d((String)TAG, (String)("initPlayout(sampleRate=" + sampleRate + ", channels=" + channels + ")"));
        int bytesPerFrame = channels * 2;
        this.byteBuffer = ByteBuffer.allocateDirect(bytesPerFrame * (sampleRate / 100));
        Log.d((String)TAG, (String)("byteBuffer.capacity: " + this.byteBuffer.capacity()));
        this.nativeCacheDirectBufferAddress(this.byteBuffer, this.nativeAudioTrack);
        int minBufferSizeInBytes = AudioTrack.getMinBufferSize((int)sampleRate, (int)(channels == 1 ? 4 : 12), (int)2) * 2;
        Log.d((String)TAG, (String)("AudioTrack.getMinBufferSize: " + minBufferSizeInBytes));
        WebRtcAudioTrack.assertTrue(this.audioTrack == null);
        WebRtcAudioTrack.assertTrue(this.byteBuffer.capacity() < minBufferSizeInBytes);
        try {
            this.audioTrack = new AudioTrack(WebRtcAudioManager.IsAndroidStreamMusic() ? 3 : 0, sampleRate, channels == 1 ? 4 : 12, 2, minBufferSizeInBytes, 1);
        }
        catch (IllegalArgumentException e) {
            Log.d((String)TAG, (String)e.getMessage());
            return false;
        }
        WebRtcAudioTrack.assertTrue(this.audioTrack.getState() == 1);
        WebRtcAudioTrack.assertTrue(this.audioTrack.getPlayState() == 1);
        return true;
    }

    private boolean startPlayout() {
        Log.d((String)TAG, (String)"startPlayout");
        WebRtcAudioTrack.assertTrue(this.audioTrack != null);
        WebRtcAudioTrack.assertTrue(this.audioThread == null);
        this.audioThread = new AudioTrackThread("AudioTrackJavaThread");
        this.audioThread.start();
        return true;
    }

    private boolean stopPlayout() {
        Log.d((String)TAG, (String)"stopPlayout");
        WebRtcAudioTrack.assertTrue(this.audioThread != null);
        this.audioThread.joinThread();
        this.audioThread = null;
        if (this.audioTrack != null) {
            this.audioTrack.release();
            this.audioTrack = null;
        }
        return true;
    }

    private int getStreamMaxVolume() {
        Log.d((String)TAG, (String)"getStreamMaxVolume");
        WebRtcAudioTrack.assertTrue(this.audioManager != null);
        return this.audioManager.getStreamMaxVolume(0);
    }

    private boolean setStreamVolume(int volume) {
        Log.d((String)TAG, (String)("setStreamVolume(" + volume + ")"));
        WebRtcAudioTrack.assertTrue(this.audioManager != null);
        if (this.isVolumeFixed()) {
            Log.e((String)TAG, (String)"The device implements a fixed volume policy.");
            return false;
        }
        this.audioManager.setStreamVolume(0, volume, 0);
        return true;
    }

    @TargetApi(value=21)
    private boolean isVolumeFixed() {
        if (!WebRtcAudioUtils.runningOnLollipopOrHigher()) {
            return false;
        }
        return this.audioManager.isVolumeFixed();
    }

    private int getStreamVolume() {
        Log.d((String)TAG, (String)"getStreamVolume");
        WebRtcAudioTrack.assertTrue(this.audioManager != null);
        return this.audioManager.getStreamVolume(0);
    }

    private static void assertTrue(boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    private native void nativeCacheDirectBufferAddress(ByteBuffer var1, long var2);

    private native void nativeGetPlayoutData(int var1, long var2);

    private class AudioTrackThread
    extends Thread {
        private volatile boolean keepAlive;

        public AudioTrackThread(String name) {
            super(name);
            this.keepAlive = true;
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)-19);
            Log.d((String)WebRtcAudioTrack.TAG, (String)("AudioTrackThread" + WebRtcAudioUtils.getThreadInfo()));
            try {
                WebRtcAudioTrack.this.audioTrack.play();
                WebRtcAudioTrack.assertTrue(WebRtcAudioTrack.this.audioTrack.getPlayState() == 3);
            }
            catch (IllegalStateException e) {
                Log.e((String)WebRtcAudioTrack.TAG, (String)("AudioTrack.play failed: " + e.getMessage()));
                return;
            }
            int sizeInBytes = WebRtcAudioTrack.this.byteBuffer.capacity();
            while (this.keepAlive) {
                WebRtcAudioTrack.this.nativeGetPlayoutData(sizeInBytes, WebRtcAudioTrack.this.nativeAudioTrack);
                WebRtcAudioTrack.assertTrue(sizeInBytes <= WebRtcAudioTrack.this.byteBuffer.remaining());
                int bytesWritten = 0;
                bytesWritten = WebRtcAudioUtils.runningOnLollipopOrHigher() ? this.writeOnLollipop(WebRtcAudioTrack.this.audioTrack, WebRtcAudioTrack.this.byteBuffer, sizeInBytes) : this.writePreLollipop(WebRtcAudioTrack.this.audioTrack, WebRtcAudioTrack.this.byteBuffer, sizeInBytes);
                if (bytesWritten != sizeInBytes) {
                    Log.e((String)WebRtcAudioTrack.TAG, (String)("AudioTrack.write failed: " + bytesWritten));
                    if (bytesWritten == -3) {
                        this.keepAlive = false;
                    }
                }
                WebRtcAudioTrack.this.byteBuffer.rewind();
            }
            try {
                WebRtcAudioTrack.this.audioTrack.stop();
            }
            catch (IllegalStateException e) {
                Log.e((String)WebRtcAudioTrack.TAG, (String)("AudioTrack.stop failed: " + e.getMessage()));
            }
            WebRtcAudioTrack.assertTrue(WebRtcAudioTrack.this.audioTrack.getPlayState() == 1);
            WebRtcAudioTrack.this.audioTrack.flush();
        }

        @TargetApi(value=21)
        private int writeOnLollipop(AudioTrack audioTrack, ByteBuffer byteBuffer, int sizeInBytes) {
            return audioTrack.write(byteBuffer, sizeInBytes, 0);
        }

        private int writePreLollipop(AudioTrack audioTrack, ByteBuffer byteBuffer, int sizeInBytes) {
            return audioTrack.write(byteBuffer.array(), byteBuffer.arrayOffset(), sizeInBytes);
        }

        public void joinThread() {
            this.keepAlive = false;
            while (this.isAlive()) {
                try {
                    this.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

